"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSimpleFormIteratorItem = void 0;
var react_1 = require("react");
var SimpleFormIteratorItemContext_1 = require("./SimpleFormIteratorItemContext");
/**
 * A hook that provides access to a SimpleFormIterator item meta (its index and the total number of items) and mutators (reorder and remove this remove).
 * Useful to create custom array input iterators.
 * @see {SimpleFormIterator}
 * @see {ArrayInput}
 */
var useSimpleFormIteratorItem = function () {
    var context = (0, react_1.useContext)(SimpleFormIteratorItemContext_1.SimpleFormIteratorItemContext);
    if (!context) {
        throw new Error('useSimpleFormIteratorItem must be used inside a SimpleFormIteratorItem');
    }
    return context;
};
exports.useSimpleFormIteratorItem = useSimpleFormIteratorItem;
//# sourceMappingURL=useSimpleFormIteratorItem.js.map