"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BooleanInput = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var clsx_1 = __importDefault(require("clsx"));
var FormControlLabel_1 = __importDefault(require("@mui/material/FormControlLabel"));
var FormHelperText_1 = __importDefault(require("@mui/material/FormHelperText"));
var FormGroup_1 = __importDefault(require("@mui/material/FormGroup"));
var Switch_1 = __importDefault(require("@mui/material/Switch"));
var ra_core_1 = require("ra-core");
var sanitizeInputRestProps_1 = require("./sanitizeInputRestProps");
var InputHelperText_1 = require("./InputHelperText");
var BooleanInput = function (props) {
    var className = props.className, _a = props.row, row = _a === void 0 ? false : _a, _b = props.defaultValue, defaultValue = _b === void 0 ? false : _b, format = props.format, label = props.label, fullWidth = props.fullWidth, helperText = props.helperText, onBlur = props.onBlur, onChange = props.onChange, onFocus = props.onFocus, readOnly = props.readOnly, disabled = props.disabled, parse = props.parse, resource = props.resource, source = props.source, validate = props.validate, _c = props.options, options = _c === void 0 ? defaultOptions : _c, sx = props.sx, rest = __rest(props, ["className", "row", "defaultValue", "format", "label", "fullWidth", "helperText", "onBlur", "onChange", "onFocus", "readOnly", "disabled", "parse", "resource", "source", "validate", "options", "sx"]);
    var _d = (0, ra_core_1.useInput)(__assign({ defaultValue: defaultValue, format: format, parse: parse, resource: resource, source: source, onBlur: onBlur, onChange: onChange, type: 'checkbox', validate: validate, disabled: disabled, readOnly: readOnly }, rest)), id = _d.id, field = _d.field, isRequired = _d.isRequired, _e = _d.fieldState, error = _e.error, invalid = _e.invalid;
    var handleChange = (0, react_1.useCallback)(function (event) {
        field.onChange(event);
        // Ensure field is considered as touched
        field.onBlur();
    }, [field]);
    var renderHelperText = helperText !== false || invalid;
    return (React.createElement(FormGroup_1.default, { className: (0, clsx_1.default)('ra-input', "ra-input-".concat(source), className), row: row, sx: sx },
        React.createElement(FormControlLabel_1.default, { inputRef: field.ref, control: React.createElement(Switch_1.default, __assign({ id: id, name: field.name, onChange: handleChange, onFocus: onFocus, checked: Boolean(field.value) }, (0, sanitizeInputRestProps_1.sanitizeInputRestProps)(rest), options, { disabled: disabled || readOnly, readOnly: readOnly })), label: React.createElement(ra_core_1.FieldTitle, { label: label, source: source, resource: resource, isRequired: isRequired }) }),
        renderHelperText ? (React.createElement(FormHelperText_1.default, { error: invalid },
            React.createElement(InputHelperText_1.InputHelperText, { error: error === null || error === void 0 ? void 0 : error.message, helperText: helperText }))) : null));
};
exports.BooleanInput = BooleanInput;
var defaultOptions = {};
//# sourceMappingURL=BooleanInput.js.map