"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchInput = void 0;
var React = __importStar(require("react"));
var styles_1 = require("@mui/material/styles");
var Search_1 = __importDefault(require("@mui/icons-material/Search"));
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var TextInput_1 = require("./TextInput");
var SearchInput = function (props) {
    var label = props.label, rest = __rest(props, ["label"]);
    var translate = (0, ra_core_1.useTranslate)();
    if (label) {
        throw new Error("<SearchInput> isn't designed to be used with a label prop. Use <TextInput> if you need a label.");
    }
    return (React.createElement(StyledTextInput, __assign({ hiddenLabel: true, label: "", resettable: true, placeholder: translate('ra.action.search'), InputProps: {
            endAdornment: (React.createElement(material_1.InputAdornment, { position: "end" },
                React.createElement(Search_1.default, { color: "disabled" }))),
        }, size: "small" }, rest)));
};
exports.SearchInput = SearchInput;
var PREFIX = 'RaSearchInput';
var StyledTextInput = (0, styles_1.styled)(TextInput_1.TextInput, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})({
    marginTop: 0,
});
//# sourceMappingURL=SearchInput.js.map