"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TranslatableInputsClasses = exports.TranslatableInputs = void 0;
var React = __importStar(require("react"));
var styles_1 = require("@mui/material/styles");
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var clsx_1 = __importDefault(require("clsx"));
var TranslatableInputsTabs_1 = require("./TranslatableInputsTabs");
var TranslatableInputsTabContent_1 = require("./TranslatableInputsTabContent");
/**
 * Provides a way to edit multiple languages for any input passed as children.
 * It expects the translatable values to have the following structure:
 * {
 *     name: {
 *         en: 'The english value',
 *         fr: 'The french value',
 *         tlh: 'The klingon value',
 *     },
 *     description: {
 *         en: 'The english value',
 *         fr: 'The french value',
 *         tlh: 'The klingon value',
 *     }
 * }
 *
 * @example <caption>Basic usage</caption>
 * <TranslatableInputs locales={['en', 'fr']}>
 *     <TextInput source="title" />
 *     <RichTextInput source="description" />
 * </TranslatableInputs>
 *
 * @example <caption>With a custom language selector</caption>
 * <TranslatableInputs
 *     selector={<MyLanguageSelector />}
 *     locales={['en', 'fr']}
 * >
 *     <TextInput source="title" />
 * </TranslatableInputs>
 *
 * const MyLanguageSelector = () => {
 *     const {
 *         locales,
 *         selectedLocale,
 *         selectLocale,
 *     } = useTranslatableContext();
 *
 *     return (
 *         <select onChange={event => selectLocale(event.target.value)}>
 *             {locales.map((locale) => (
 *                 <option selected={locale === selectedLocale}>
 *                     {locale}
 *                 </option>
 *             ))}
 *        </select>
 *     );
 * }
 *
 * @param props The component props
 * @param {string} props.defaultLocale The locale selected by default. Default to 'en'.
 * @param {string[]} props.locales An array of the possible locales. For example: `['en', 'fr'].
 * @param {ReactElement} props.selector The element responsible for selecting a locale. Defaults to Material UI tabs.
 */
var TranslatableInputs = function (inProps) {
    var _a;
    var props = (0, material_1.useThemeProps)({
        props: inProps,
        name: 'RaTranslatableInputs',
    });
    var className = props.className, defaultLocale = props.defaultLocale, fullWidth = props.fullWidth, locales = props.locales, _b = props.groupKey, groupKey = _b === void 0 ? '' : _b, _c = props.selector, selector = _c === void 0 ? React.createElement(TranslatableInputsTabs_1.TranslatableInputsTabs, { groupKey: groupKey }) : _c, children = props.children, margin = props.margin, sx = props.sx, _d = props.StackProps, StackProps = _d === void 0 ? {} : _d;
    var context = (0, ra_core_1.useTranslatable)({ defaultLocale: defaultLocale, locales: locales });
    return (React.createElement(Root, { className: (0, clsx_1.default)(className, exports.TranslatableInputsClasses.root, (_a = {},
            _a[exports.TranslatableInputsClasses.fullWidth] = fullWidth,
            _a)), sx: sx },
        React.createElement(ra_core_1.TranslatableContextProvider, { value: context },
            selector,
            locales.map(function (locale) { return (React.createElement(TranslatableInputsTabContent_1.TranslatableInputsTabContent, __assign({ key: locale, locale: locale, groupKey: groupKey, margin: margin }, StackProps), children)); }))));
};
exports.TranslatableInputs = TranslatableInputs;
var PREFIX = 'RaTranslatableInputs';
exports.TranslatableInputsClasses = {
    root: "".concat(PREFIX, "-root"),
    fullWidth: "".concat(PREFIX, "-fullWidth"),
};
var Root = (0, styles_1.styled)('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flexGrow: 1,
            marginTop: theme.spacing(1),
            marginBottom: theme.spacing(0.5)
        },
        _b["&.".concat(exports.TranslatableInputsClasses.fullWidth)] = {
            width: '100%',
        },
        _b);
});
//# sourceMappingURL=TranslatableInputs.js.map