"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckForApplicationUpdate = void 0;
var React = __importStar(require("react"));
var ra_core_1 = require("ra-core");
var ApplicationUpdatedNotification_1 = require("./ApplicationUpdatedNotification");
/**
 * Display a notification asking users to reload the page when the application code has changed.
 *
 * @param {CheckForApplicationUpdateProps} props
 * @param {boolean} options.disabled Optional. Whether the check should be disabled. Defaults to false.
 * @param {string|ReactElement} props.notification The notification to display to the user. Displayed only if `updateMode` is manual. Defaults to `<ApplicationUpdatedNotification />`.
 * @param {string} options.url Optional. The URL to download to check for code update. Defaults to the current URL.
 * @param {RequestInit} options.fetchOptions Optional. The options passed to fetch function when checking for update.
 * @param {number} options.interval Optional. The interval in milliseconds between two checks. Defaults to 3600000 (1 hour).
 *
 * @example <caption>Basic usage</caption>
 * import { Admin, Resource, Layout, CheckForApplicationUpdate, ListGuesser } from 'react-admin';
 *
 * const MyLayout = ({ children }) => (
 *   <Layout>
 *     {children}
 *     <CheckForApplicationUpdate />
 *   </Layout>
 * );
 *
 * const App = () => (
 *   <Admin layout={MyLayout}>
 *      <Resource name="posts" list={ListGuesser} />
 *   </Admin>
 * );
 *
 * @example <caption>Custom notification</caption>
 * import { forwardRef } from 'react';
 * import { Admin, Resource, Layout, CheckForApplicationUpdate, ListGuesser } from 'react-admin';
 *
 * const CustomAppUpdatedNotification = forwardRef((props, ref) => (
 *   <Alert
 *     ref={ref}
 *     severity="info"
 *     action={
 *       <Button
 *         color="inherit"
 *         size="small"
 *         onClick={() => window.location.reload()}
 *       >
 *         Update
 *       </Button>
 *     }
 *   >
 *     A new version of the application is available. Please update.
 *   </Alert>
 * ));
 *
 * const MyLayout = ({ children }) => (
 *   <Layout>
 *     {children}
 *     <CheckForApplicationUpdate notification={<CustomAppUpdatedNotification />} />
 *   </Layout>
 * );
 *
 * const App = () => (
 *   <Admin layout={MyLayout}>
 *      <Resource name="posts" list={ListGuesser} />
 *   </Admin>
 * );
 */
var CheckForApplicationUpdate = function (props) {
    var _a = props.notification, notification = _a === void 0 ? DEFAULT_NOTIFICATION : _a, rest = __rest(props, ["notification"]);
    var notify = (0, ra_core_1.useNotify)();
    var onNewVersionAvailable = function () {
        notify(notification, {
            type: 'info',
            autoHideDuration: null,
        });
    };
    (0, ra_core_1.useCheckForApplicationUpdate)(__assign({ onNewVersionAvailable: onNewVersionAvailable }, rest));
    return null;
};
exports.CheckForApplicationUpdate = CheckForApplicationUpdate;
var DEFAULT_NOTIFICATION = React.createElement(ApplicationUpdatedNotification_1.ApplicationUpdatedNotification, null);
//# sourceMappingURL=CheckForApplicationUpdate.js.map