"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LayoutClasses = exports.Layout = void 0;
var react_1 = __importStar(require("react"));
var react_error_boundary_1 = require("react-error-boundary");
var clsx_1 = __importDefault(require("clsx"));
var styles_1 = require("@mui/material/styles");
var AppBar_1 = require("./AppBar");
var Sidebar_1 = require("./Sidebar");
var Menu_1 = require("./Menu");
var Error_1 = require("./Error");
var button_1 = require("../button");
var preferences_1 = require("../preferences");
var Loading_1 = require("./Loading");
var Layout = function (props) {
    var _a = props.appBar, AppBar = _a === void 0 ? AppBar_1.AppBar : _a, appBarAlwaysOn = props.appBarAlwaysOn, children = props.children, className = props.className, errorComponent = props.error, _b = props.menu, Menu = _b === void 0 ? Menu_1.Menu : _b, _c = props.sidebar, Sidebar = _c === void 0 ? Sidebar_1.Sidebar : _c, rest = __rest(props, ["appBar", "appBarAlwaysOn", "children", "className", "error", "menu", "sidebar"]);
    var _d = (0, react_1.useState)(undefined), errorInfo = _d[0], setErrorInfo = _d[1];
    var handleError = function (error, info) {
        setErrorInfo(info);
    };
    return (react_1.default.createElement(Core, __assign({ className: (0, clsx_1.default)('layout', className) }, rest),
        react_1.default.createElement(button_1.SkipNavigationButton, null),
        react_1.default.createElement("div", { className: exports.LayoutClasses.appFrame },
            react_1.default.createElement(AppBar, { alwaysOn: appBarAlwaysOn }),
            react_1.default.createElement("main", { className: exports.LayoutClasses.contentWithSidebar },
                react_1.default.createElement(Sidebar, { appBarAlwaysOn: appBarAlwaysOn },
                    react_1.default.createElement(Menu, null)),
                react_1.default.createElement("div", { id: "main-content", className: exports.LayoutClasses.content },
                    react_1.default.createElement(react_error_boundary_1.ErrorBoundary, { onError: handleError, fallbackRender: function (_a) {
                            var error = _a.error, resetErrorBoundary = _a.resetErrorBoundary;
                            return (react_1.default.createElement(Error_1.Error, { error: error, errorComponent: errorComponent, errorInfo: errorInfo, resetErrorBoundary: resetErrorBoundary }));
                        } },
                        react_1.default.createElement(react_1.Suspense, { fallback: react_1.default.createElement(Loading_1.Loading, null) }, children)))),
            react_1.default.createElement(preferences_1.Inspector, null))));
};
exports.Layout = Layout;
var PREFIX = 'RaLayout';
exports.LayoutClasses = {
    appFrame: "".concat(PREFIX, "-appFrame"),
    contentWithSidebar: "".concat(PREFIX, "-contentWithSidebar"),
    content: "".concat(PREFIX, "-content"),
};
var Core = (0, styles_1.styled)('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b, _c, _d;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flexDirection: 'column',
            zIndex: 1,
            minHeight: '100vh',
            backgroundColor: theme.palette.background.default,
            position: 'relative',
            minWidth: 'fit-content',
            width: '100%',
            color: theme.palette.getContrastText(theme.palette.background.default)
        },
        _b["& .".concat(exports.LayoutClasses.appFrame)] = (_c = {
                display: 'flex',
                flexDirection: 'column',
                flexGrow: 1,
                marginTop: theme.spacing(6)
            },
            _c[theme.breakpoints.down('sm')] = {
                marginTop: theme.spacing(7),
            },
            _c),
        _b["& .".concat(exports.LayoutClasses.contentWithSidebar)] = {
            display: 'flex',
            flexGrow: 1,
            transition: theme.transitions.create('margin', {
                easing: theme.transitions.easing.easeOut,
                duration: theme.transitions.duration.enteringScreen,
            }),
        },
        _b["& .".concat(exports.LayoutClasses.content)] = (_d = {
                backgroundColor: theme.palette.background.default,
                zIndex: 2,
                display: 'flex',
                flexDirection: 'column',
                flexGrow: 1,
                flexBasis: 0,
                padding: 0
            },
            _d[theme.breakpoints.up('xs')] = {
                paddingRight: theme.spacing(1),
                paddingLeft: theme.spacing(1),
            },
            _d),
        _b);
});
//# sourceMappingURL=Layout.js.map