"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadingIndicatorClasses = exports.LoadingIndicator = void 0;
var React = __importStar(require("react"));
var styles_1 = require("@mui/material/styles");
var clsx_1 = __importDefault(require("clsx"));
var styles_2 = require("@mui/material/styles");
var CircularProgress_1 = __importDefault(require("@mui/material/CircularProgress"));
var ra_core_1 = require("ra-core");
var button_1 = require("../button");
var LoadingIndicator = function (props) {
    var className = props.className, onClick = props.onClick, sx = props.sx, rest = __rest(props, ["className", "onClick", "sx"]);
    var loading = (0, ra_core_1.useLoading)();
    var theme = (0, styles_2.useTheme)();
    return (React.createElement(Root, { className: className, sx: sx },
        React.createElement(button_1.RefreshIconButton, { className: "".concat(exports.LoadingIndicatorClasses.loadedIcon, " ").concat(loading && exports.LoadingIndicatorClasses.loadedLoading), onClick: onClick }),
        loading && (React.createElement(CircularProgress_1.default, __assign({ className: (0, clsx_1.default)('app-loader', exports.LoadingIndicatorClasses.loader), color: "inherit", size: theme.spacing(2), thickness: 6 }, rest)))));
};
exports.LoadingIndicator = LoadingIndicator;
var PREFIX = 'RaLoadingIndicator';
exports.LoadingIndicatorClasses = {
    loader: "".concat(PREFIX, "-loader"),
    loadedLoading: "".concat(PREFIX, "-loadedLoading"),
    loadedIcon: "".concat(PREFIX, "-loadedIcon"),
};
var Root = (0, styles_1.styled)('div', {
    name: PREFIX,
    overridesResolver: function (_, styles) { return styles.root; },
})((_a = {
        position: 'relative'
    },
    _a["& .".concat(exports.LoadingIndicatorClasses.loadedIcon)] = (_b = {},
        _b["&.".concat(exports.LoadingIndicatorClasses.loadedLoading)] = {
            opacity: 0,
        },
        _b),
    _a["& .".concat(exports.LoadingIndicatorClasses.loader)] = {
        position: 'absolute',
        top: '30%',
        left: '30%',
    },
    _a));
//# sourceMappingURL=LoadingIndicator.js.map