"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CLOSED_DRAWER_WIDTH = exports.DRAWER_WIDTH = exports.SidebarClasses = exports.Sidebar = void 0;
var React = __importStar(require("react"));
var styles_1 = require("@mui/material/styles");
var material_1 = require("@mui/material");
var get_1 = __importDefault(require("lodash/get"));
var ra_core_1 = require("ra-core");
var useSidebarState_1 = require("./useSidebarState");
var Sidebar = function (props) {
    var appBarAlwaysOn = props.appBarAlwaysOn, children = props.children, closedSize = props.closedSize, size = props.size, rest = __rest(props, ["appBarAlwaysOn", "children", "closedSize", "size"]);
    var isXSmall = (0, material_1.useMediaQuery)(function (theme) {
        return theme.breakpoints.down('sm');
    });
    var _a = (0, useSidebarState_1.useSidebarState)(), open = _a[0], setOpen = _a[1];
    (0, ra_core_1.useLocale)(); // force redraw on locale change
    var trigger = (0, material_1.useScrollTrigger)();
    var toggleSidebar = function () { return setOpen(!open); };
    return isXSmall ? (React.createElement(StyledDrawer, __assign({ variant: "temporary", open: open, onClose: toggleSidebar, classes: exports.SidebarClasses }, rest), children)) : (React.createElement(StyledDrawer, __assign({ variant: "permanent", open: open, onClose: toggleSidebar, classes: exports.SidebarClasses, className: trigger && !appBarAlwaysOn ? exports.SidebarClasses.appBarCollapsed : '' }, rest),
        React.createElement("div", { className: exports.SidebarClasses.fixed }, children)));
};
exports.Sidebar = Sidebar;
var PREFIX = 'RaSidebar';
exports.SidebarClasses = {
    docked: "".concat(PREFIX, "-docked"),
    paper: "".concat(PREFIX, "-paper"),
    paperAnchorLeft: "".concat(PREFIX, "-paperAnchorLeft"),
    paperAnchorRight: "".concat(PREFIX, "-paperAnchorRight"),
    paperAnchorTop: "".concat(PREFIX, "-paperAnchorTop"),
    paperAnchorBottom: "".concat(PREFIX, "-paperAnchorBottom"),
    paperAnchorDockedLeft: "".concat(PREFIX, "-paperAnchorDockedLeft"),
    paperAnchorDockedTop: "".concat(PREFIX, "-paperAnchorDockedTop"),
    paperAnchorDockedRight: "".concat(PREFIX, "-paperAnchorDockedRight"),
    paperAnchorDockedBottom: "".concat(PREFIX, "-paperAnchorDockedBottom"),
    modal: "".concat(PREFIX, "-modal"),
    fixed: "".concat(PREFIX, "-fixed"),
    appBarCollapsed: "".concat(PREFIX, "-appBarCollapsed"),
};
var StyledDrawer = (0, styles_1.styled)(material_1.Drawer, {
    name: PREFIX,
    slot: 'Root',
    overridesResolver: function (props, styles) { return styles.root; },
    shouldForwardProp: function () { return true; },
})(function (_a) {
    var _b, _c, _d;
    var open = _a.open, theme = _a.theme;
    return (_b = {
            height: 'calc(100vh - 3em)',
            marginTop: 0,
            transition: theme.transitions.create('margin', {
                easing: theme.transitions.easing.easeOut,
                duration: theme.transitions.duration.enteringScreen,
            })
        },
        _b["&.".concat(exports.SidebarClasses.appBarCollapsed)] = (_c = {
                // compensate the margin of the Layout appFrame instead of removing it in the Layout
                // because otherwise, the appFrame content without margin may revert the scrollTrigger,
                // leading to a visual jiggle
                marginTop: theme.spacing(-6)
            },
            _c[theme.breakpoints.down('sm')] = {
                marginTop: theme.spacing(-7),
            },
            _c.transition = theme.transitions.create('margin', {
                easing: theme.transitions.easing.sharp,
                duration: theme.transitions.duration.leavingScreen,
            }),
            _c),
        _b["& .".concat(exports.SidebarClasses.docked)] = {},
        _b["& .".concat(exports.SidebarClasses.paper)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorLeft)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorRight)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorTop)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorBottom)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorDockedLeft)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorDockedTop)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorDockedRight)] = {},
        _b["& .".concat(exports.SidebarClasses.paperAnchorDockedBottom)] = {},
        _b["& .".concat(exports.SidebarClasses.modal)] = {},
        _b["& .".concat(exports.SidebarClasses.fixed)] = {
            position: 'fixed',
            height: 'calc(100vh - 3em)',
            overflowX: 'hidden',
            // hide scrollbar
            scrollbarWidth: 'none',
            msOverflowStyle: 'none',
            '&::-webkit-scrollbar': {
                display: 'none',
            },
        },
        _b["& .MuiPaper-root"] = (_d = {
                position: 'relative',
                width: open
                    ? (0, get_1.default)(theme, 'sidebar.width', exports.DRAWER_WIDTH)
                    : (0, get_1.default)(theme, 'sidebar.closedWidth', exports.CLOSED_DRAWER_WIDTH),
                transition: theme.transitions.create('width', {
                    easing: theme.transitions.easing.sharp,
                    duration: theme.transitions.duration.leavingScreen,
                }),
                backgroundColor: 'transparent',
                borderRight: 'none'
            },
            _d[theme.breakpoints.only('xs')] = {
                marginTop: 0,
                height: '100vh',
                position: 'inherit',
                backgroundColor: theme.palette.background.default,
            },
            _d[theme.breakpoints.up('md')] = {
                border: 'none',
            },
            _d.zIndex = 'inherit',
            _d),
        _b);
});
exports.DRAWER_WIDTH = 240;
exports.CLOSED_DRAWER_WIDTH = 55;
//# sourceMappingURL=Sidebar.js.map