"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useUserMenu = void 0;
var react_1 = require("react");
var UserMenuContext_1 = require("./UserMenuContext");
/**
 * A hook to retrieve the user menu context, which provides access to a function for closing the user menu.
 * @returns {UserMenuContextValue}
 *
 * @example
 * import { Logout, MenuItemLink, UserMenu, useUserMenu } from 'react-admin';
 *
 * const ConfigurationMenu = () => {
 *     const { onClose } = useUserMenu();
 *     return (
 *         <MenuItemLink
 *             to="/configuration"
 *             primaryText="pos.configuration"
 *             leftIcon={<SettingsIcon />}
 *             sidebarIsOpen
 *             onClick={onClose}
 *         />
 *     );
 * };
 *
 * export const MyUserMenu = () => (
 *     <UserMenu>
 *         <ConfigurationMenu />
 *         <Logout />
 *     </UserMenu>
 * );
 */
var useUserMenu = function () { return (0, react_1.useContext)(UserMenuContext_1.UserMenuContext); };
exports.useUserMenu = useUserMenu;
//# sourceMappingURL=useUserMenu.js.map