"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Count = void 0;
var React = __importStar(require("react"));
var ra_core_1 = require("ra-core");
var material_1 = require("@mui/material");
var Error_1 = __importDefault(require("@mui/icons-material/Error"));
var Link_1 = require("../Link");
/**
 * Fetch and render the number of records of a given resource
 *
 * Relies on dataProvider.getList() returning a total property
 *
 * @example // Display the number of records in the current resource (based on ResourceContext)
 * <Count />
 *
 * @example // Display the number of posts
 * <Count resource="posts" />
 *
 * @example // Display the number of published posts
 * <Count resource="posts" filter={{ is_published: true }}/>
 *
 * @example // Display the number of posts, with a custom Typography variant
 * <Count resource="posts" variant="h1" />
 *
 * @see ReferenceManyCount for a similar component which fetches the number of records related to the current one
 */
var Count = function (props) {
    var filter = props.filter, sort = props.sort, link = props.link, resourceFromProps = props.resource, _a = props.timeout, timeout = _a === void 0 ? 1000 : _a, rest = __rest(props, ["filter", "sort", "link", "resource", "timeout"]);
    var resource = (0, ra_core_1.useResourceContext)(props);
    if (!resource) {
        throw new Error('The Count component must be used inside a ResourceContext or must be passed a resource prop.');
    }
    var oneSecondHasPassed = (0, ra_core_1.useTimeout)(timeout);
    var createPath = (0, ra_core_1.useCreatePath)();
    var _b = (0, ra_core_1.useGetList)(resource, {
        filter: filter,
        sort: sort,
        pagination: { perPage: 1, page: 1 },
    }), total = _b.total, isPending = _b.isPending, error = _b.error;
    var body = isPending ? (oneSecondHasPassed ? (React.createElement(material_1.CircularProgress, { size: 14 })) : ('')) : error ? (React.createElement(Error_1.default, { color: "error", fontSize: "small", titleAccess: "error" })) : (total);
    return link ? (
    // @ts-ignore TypeScript complains that the props for <a> aren't the same as for <span>
    React.createElement(Link_1.Link, __assign({ to: {
            pathname: createPath({ resource: resource, type: 'list' }),
            search: filter ? "filter=".concat(JSON.stringify(filter)) : undefined,
        }, variant: "body2", onClick: function (e) { return e.stopPropagation(); } }, rest), body)) : (React.createElement(material_1.Typography, __assign({ component: "span", variant: "body2" }, rest), body));
};
exports.Count = Count;
//# sourceMappingURL=Count.js.map