"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleListLoadingClasses = exports.SimpleListLoading = void 0;
var React = __importStar(require("react"));
var styles_1 = require("@mui/material/styles");
var Avatar_1 = __importDefault(require("@mui/material/Avatar"));
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var Placeholder_1 = require("../Placeholder");
var SimpleListLoading = function (props) {
    var className = props.className, hasLeftAvatarOrIcon = props.hasLeftAvatarOrIcon, hasRightAvatarOrIcon = props.hasRightAvatarOrIcon, hasSecondaryText = props.hasSecondaryText, hasTertiaryText = props.hasTertiaryText, _a = props.nbFakeLines, nbFakeLines = _a === void 0 ? 5 : _a, rest = __rest(props, ["className", "hasLeftAvatarOrIcon", "hasRightAvatarOrIcon", "hasSecondaryText", "hasTertiaryText", "nbFakeLines"]);
    var oneSecondHasPassed = (0, ra_core_1.useTimeout)(1000);
    return oneSecondHasPassed ? (React.createElement(StyledList, __assign({ className: className }, rest), times(nbFakeLines, function (key) { return (React.createElement(material_1.ListItem, { key: key },
        hasLeftAvatarOrIcon && (React.createElement(material_1.ListItemAvatar, null,
            React.createElement(Avatar_1.default, null, "\u00A0"))),
        React.createElement(material_1.ListItemText, { primary: React.createElement("div", null,
                React.createElement(Placeholder_1.Placeholder, { className: exports.SimpleListLoadingClasses.primary }),
                hasTertiaryText && (React.createElement("span", { className: exports.SimpleListLoadingClasses.tertiary },
                    React.createElement(Placeholder_1.Placeholder, null)))), secondary: hasSecondaryText ? React.createElement(Placeholder_1.Placeholder, null) : undefined }),
        hasRightAvatarOrIcon && (React.createElement(material_1.ListItemSecondaryAction, null,
            React.createElement(Avatar_1.default, null, "\u00A0"))))); }))) : null;
};
exports.SimpleListLoading = SimpleListLoading;
var PREFIX = 'RaSimpleListLoading';
exports.SimpleListLoadingClasses = {
    primary: "".concat(PREFIX, "-primary"),
    tertiary: "".concat(PREFIX, "-tertiary"),
};
var StyledList = (0, styles_1.styled)(material_1.List, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(exports.SimpleListLoadingClasses.primary)] = {
            width: '30vw',
            display: 'inline-block',
            marginBottom: theme.spacing(),
        },
        _b["& .".concat(exports.SimpleListLoadingClasses.tertiary)] = {
            float: 'right',
            opacity: 0.541176,
            minWidth: '10vw',
        },
        _b);
});
var times = function (nbChildren, fn) {
    return Array.from({ length: nbChildren }, function (_, key) { return fn(key); });
};
//# sourceMappingURL=SimpleListLoading.js.map