"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SingleFieldListClasses = exports.SingleFieldList = void 0;
var React = __importStar(require("react"));
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var LinearProgress_1 = require("../layout/LinearProgress");
var Link_1 = require("../Link");
/**
 * Iterator component to be used to display a list of entities, using a single field
 *
 * @example Display all the orders by the current customer as a list of chips
 * <ReferenceManyField reference="orders" target="customer_id">
 *     <SingleFieldList />
 * </ReferenceManyField>

* @example Choose the field to be used as text label
 * <ReferenceManyField reference="orders" target="customer_id">
 *     <SingleFieldList>
 *         <ChipField source="reference" />
 *     </SingleFieldList>
 * </ReferenceManyField>
 *
 * @example Customize the link type
 * // By default, it includes a link to the <Edit> page of the related record
 * // (`/orders/:id` in the previous example).
 * // Set the linkType prop to "show" to link to the <Show> page instead.
 * <ReferenceManyField reference="books" target="author_id">
 *     <SingleFieldList linkType="show">
 *         <ChipField source="title" />
 *     </SingleFieldList>
 * </ReferenceManyField>
 *
 * @example Disable the link
 * // You can also prevent `<SingleFieldList>` from adding link to children by
 * // setting `linkType` to false.
 * <ReferenceManyField reference="books" target="author_id">
 *     <SingleFieldList linkType={false}>
 *         <ChipField source="title" />
 *     </SingleFieldList>
 * </ReferenceManyField>
 */
var SingleFieldList = function (props) {
    var className = props.className, children = props.children, empty = props.empty, _a = props.linkType, linkType = _a === void 0 ? 'edit' : _a, _b = props.gap, gap = _b === void 0 ? 1 : _b, _c = props.direction, direction = _c === void 0 ? 'row' : _c, rest = __rest(props, ["className", "children", "empty", "linkType", "gap", "direction"]);
    var _d = (0, ra_core_1.useListContextWithProps)(props), data = _d.data, total = _d.total, isPending = _d.isPending;
    var resource = (0, ra_core_1.useResourceContext)(props);
    var createPath = (0, ra_core_1.useCreatePath)();
    if (isPending === true) {
        return React.createElement(LinearProgress_1.LinearProgress, null);
    }
    if (data == null || data.length === 0 || total === 0) {
        if (empty) {
            return empty;
        }
        return null;
    }
    return (React.createElement(Root, __assign({ gap: gap, direction: direction, className: className }, (0, ra_core_1.sanitizeListRestProps)(rest)), data.map(function (record, rowIndex) {
        var _a, _b;
        var resourceLinkPath = !linkType
            ? false
            : createPath({
                resource: resource,
                type: linkType,
                id: record.id,
            });
        if (resourceLinkPath) {
            return (React.createElement(ra_core_1.RecordContextProvider, { value: record, key: (_a = record.id) !== null && _a !== void 0 ? _a : "row".concat(rowIndex) },
                React.createElement(Link_1.Link, { className: exports.SingleFieldListClasses.link, to: resourceLinkPath, onClick: stopPropagation }, children || (React.createElement(DefaultChildComponent, { clickable: true })))));
        }
        return (React.createElement(ra_core_1.RecordContextProvider, { value: record, key: (_b = record.id) !== null && _b !== void 0 ? _b : "row".concat(rowIndex) }, children || React.createElement(DefaultChildComponent, null)));
    })));
};
exports.SingleFieldList = SingleFieldList;
var PREFIX = 'RaSingleFieldList';
exports.SingleFieldListClasses = {
    link: "".concat(PREFIX, "-link"),
};
var Root = (0, material_1.styled)(material_1.Stack, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flexWrap: 'wrap'
        },
        _b["& .".concat(exports.SingleFieldListClasses.link)] = {
            textDecoration: 'none',
            '& > *': {
                color: theme.palette.primary.main,
            },
        },
        _b);
});
// useful to prevent click bubbling in a datagrid with rowClick
var stopPropagation = function (e) { return e.stopPropagation(); };
var DefaultChildComponent = function (_a) {
    var clickable = _a.clickable;
    return (React.createElement(material_1.Chip, { sx: { cursor: 'inherit' }, size: "small", label: React.createElement(ra_core_1.RecordRepresentation, null), clickable: clickable }));
};
//# sourceMappingURL=SingleFieldList.js.map