"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PureDatagridBody = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var material_1 = require("@mui/material");
var clsx_1 = __importDefault(require("clsx"));
var ra_core_1 = require("ra-core");
var useDatagridStyles_1 = require("./useDatagridStyles");
var DatagridRow_1 = __importStar(require("./DatagridRow"));
var DatagridBody = React.forwardRef(function (_a, ref) {
    var children = _a.children, className = _a.className, _b = _a.data, data = _b === void 0 ? defaultData : _b, expand = _a.expand, _c = _a.hasBulkActions, hasBulkActions = _c === void 0 ? false : _c, hover = _a.hover, onToggleItem = _a.onToggleItem, resource = _a.resource, _d = _a.row, row = _d === void 0 ? defaultChildren : _d, rowClick = _a.rowClick, rowSx = _a.rowSx, rowStyle = _a.rowStyle, selectedIds = _a.selectedIds, isRowSelectable = _a.isRowSelectable, rest = __rest(_a, ["children", "className", "data", "expand", "hasBulkActions", "hover", "onToggleItem", "resource", "row", "rowClick", "rowSx", "rowStyle", "selectedIds", "isRowSelectable"]);
    return (React.createElement(material_1.TableBody, __assign({ ref: ref, className: (0, clsx_1.default)('datagrid-body', className, useDatagridStyles_1.DatagridClasses.tbody) }, rest), data.map(function (record, rowIndex) {
        var _a;
        var _b, _c;
        return (React.createElement(ra_core_1.RecordContextProvider, { value: record, key: (_b = record.id) !== null && _b !== void 0 ? _b : "row".concat(rowIndex) }, (0, react_1.cloneElement)(row, {
            className: (0, clsx_1.default)(useDatagridStyles_1.DatagridClasses.row, (_a = {},
                _a[useDatagridStyles_1.DatagridClasses.rowEven] = rowIndex % 2 === 0,
                _a[useDatagridStyles_1.DatagridClasses.rowOdd] = rowIndex % 2 !== 0,
                _a)),
            expand: expand,
            hasBulkActions: hasBulkActions && !!selectedIds,
            hover: hover,
            id: (_c = record.id) !== null && _c !== void 0 ? _c : "row".concat(rowIndex),
            onToggleItem: onToggleItem,
            resource: resource,
            rowClick: rowClick,
            selectable: !isRowSelectable || isRowSelectable(record),
            selected: selectedIds === null || selectedIds === void 0 ? void 0 : selectedIds.includes(record.id),
            sx: rowSx === null || rowSx === void 0 ? void 0 : rowSx(record, rowIndex),
            style: rowStyle === null || rowStyle === void 0 ? void 0 : rowStyle(record, rowIndex),
        }, children)));
    })));
});
var defaultChildren = React.createElement(DatagridRow_1.default, null);
var defaultData = [];
// trick Material UI Table into thinking this is one of the child type it supports
// @ts-ignore
DatagridBody.muiName = 'TableBody';
exports.PureDatagridBody = (0, react_1.memo)(function (props) { return (React.createElement(DatagridBody, __assign({ row: React.createElement(DatagridRow_1.PureDatagridRow, null) }, props))); });
// trick Material UI Table into thinking this is one of the child type it supports
// @ts-ignore
exports.PureDatagridBody.muiName = 'TableBody';
exports.default = DatagridBody;
//# sourceMappingURL=DatagridBody.js.map