"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PureDatagridRow = void 0;
var react_1 = __importStar(require("react"));
var clsx_1 = __importDefault(require("clsx"));
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var react_router_dom_1 = require("react-router-dom");
var DatagridCell_1 = __importDefault(require("./DatagridCell"));
var ExpandRowButton_1 = __importDefault(require("./ExpandRowButton"));
var useDatagridStyles_1 = require("./useDatagridStyles");
var useDatagridContext_1 = require("./useDatagridContext");
var computeNbColumns = function (expand, children, hasBulkActions) {
    return expand
        ? 1 + // show expand button
            (hasBulkActions ? 1 : 0) + // checkbox column
            react_1.default.Children.toArray(children).filter(function (child) { return !!child; }).length // non-null children
        : 0;
}; // we don't need to compute columns if there is no expand panel;
var DatagridRow = react_1.default.forwardRef(function (props, ref) {
    var _a, _b;
    var children = props.children, className = props.className, expand = props.expand, _c = props.hasBulkActions, hasBulkActions = _c === void 0 ? false : _c, _d = props.hover, hover = _d === void 0 ? true : _d, id = props.id, onToggleItem = props.onToggleItem, recordOverride = props.record, rowClick = props.rowClick, _e = props.selected, selected = _e === void 0 ? false : _e, style = props.style, _f = props.selectable, selectable = _f === void 0 ? true : _f, rest = __rest(props, ["children", "className", "expand", "hasBulkActions", "hover", "id", "onToggleItem", "record", "rowClick", "selected", "style", "selectable"]);
    if (typeof id === 'undefined') {
        throw new Error('DatagridRow expects an id prop');
    }
    var context = (0, useDatagridContext_1.useDatagridContext)();
    var translate = (0, ra_core_1.useTranslate)();
    var record = (0, ra_core_1.useRecordContext)(props);
    if (!record) {
        throw new Error('DatagridRow can only be used within a RecordContext or be passed a record prop');
    }
    var resource = (0, ra_core_1.useResourceContext)(props);
    var resourceDefinition = (0, ra_core_1.useResourceDefinition)(props);
    var hasDetailView = resourceDefinition.hasShow || resourceDefinition.hasEdit;
    if (!resource) {
        throw new Error('DatagridRow can only be used within a ResourceContext or be passed a resource prop');
    }
    var expandable = (!context ||
        !context.isRowExpandable ||
        context.isRowExpandable(record)) &&
        expand;
    var _g = (0, ra_core_1.useExpanded)(resource, id, context && context.expandSingle), expanded = _g[0], toggleExpanded = _g[1];
    var _h = (0, react_1.useState)(function () {
        return computeNbColumns(expandable, children, hasBulkActions);
    }), nbColumns = _h[0], setNbColumns = _h[1];
    (0, react_1.useEffect)(function () {
        // Fields can be hidden dynamically based on permissions;
        // The expand panel must span over the remaining columns
        // So we must recompute the number of columns to span on
        var newNbColumns = computeNbColumns(expandable, children, hasBulkActions);
        if (newNbColumns !== nbColumns) {
            setNbColumns(newNbColumns);
        }
    }, [expandable, nbColumns, children, hasBulkActions]);
    var navigate = (0, react_router_dom_1.useNavigate)();
    var handleToggleExpand = (0, react_1.useCallback)(function (event) {
        toggleExpanded();
        event.stopPropagation();
    }, [toggleExpanded]);
    var handleToggleSelection = (0, react_1.useCallback)(function (event) {
        if (!selectable || !onToggleItem)
            return;
        onToggleItem(id, event);
        event.stopPropagation();
    }, [id, onToggleItem, selectable]);
    var getPathForRecord = (0, ra_core_1.useGetPathForRecordCallback)();
    var handleClick = (0, react_1.useCallback)(function (event) { return __awaiter(void 0, void 0, void 0, function () {
        var path;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    event.persist();
                    return [4 /*yield*/, getPathForRecord({
                            record: record,
                            resource: resource,
                            link: typeof rowClick === 'function'
                                ? function (record, resource) {
                                    return rowClick(record.id, resource, record);
                                }
                                : rowClick,
                        })];
                case 1:
                    path = _a.sent();
                    if (rowClick === 'expand') {
                        handleToggleExpand(event);
                        return [2 /*return*/];
                    }
                    if (rowClick === 'toggleSelection') {
                        handleToggleSelection(event);
                        return [2 /*return*/];
                    }
                    if (path === false || path == null) {
                        return [2 /*return*/];
                    }
                    navigate(path, {
                        state: { _scrollToTop: true },
                    });
                    return [2 /*return*/];
            }
        });
    }); }, [
        record,
        resource,
        rowClick,
        navigate,
        handleToggleExpand,
        handleToggleSelection,
        getPathForRecord,
    ]);
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(material_1.TableRow, __assign({ ref: ref, className: (0, clsx_1.default)(className, (_a = {},
                _a[useDatagridStyles_1.DatagridClasses.expandable] = expandable,
                _a[useDatagridStyles_1.DatagridClasses.selectable] = selectable,
                _a[useDatagridStyles_1.DatagridClasses.clickableRow] = rowClick !== null && rowClick !== void 0 ? rowClick : hasDetailView,
                _a)), key: id, style: style, hover: hover, onClick: handleClick }, rest),
            expand && (react_1.default.createElement(material_1.TableCell, { padding: "none", className: useDatagridStyles_1.DatagridClasses.expandIconCell }, expandable && (react_1.default.createElement(ExpandRowButton_1.default, { className: (0, clsx_1.default)(useDatagridStyles_1.DatagridClasses.expandIcon, (_b = {},
                    _b[useDatagridStyles_1.DatagridClasses.expanded] = expanded,
                    _b)), expanded: expanded, onClick: handleToggleExpand, expandContentId: "".concat(id, "-expand") })))),
            hasBulkActions && (react_1.default.createElement(material_1.TableCell, { padding: "checkbox" },
                react_1.default.createElement(material_1.Checkbox, { "aria-label": translate('ra.action.select_row', {
                        _: 'Select this row',
                    }), color: "primary", className: "select-item ".concat(useDatagridStyles_1.DatagridClasses.checkbox), checked: selectable && selected, onClick: handleToggleSelection, disabled: !selectable }))),
            react_1.default.Children.map(children, function (field, index) {
                return (0, react_1.isValidElement)(field) ? (react_1.default.createElement(DatagridCell_1.default, { key: "".concat(id, "-").concat(field.props.source || index), className: (0, clsx_1.default)("column-".concat(field.props.source), useDatagridStyles_1.DatagridClasses.rowCell), record: record, field: field, resource: resource })) : null;
            })),
        expandable && expanded && (react_1.default.createElement(material_1.TableRow, { key: "".concat(id, "-expand"), id: "".concat(id, "-expand"), className: useDatagridStyles_1.DatagridClasses.expandedPanel },
            react_1.default.createElement(material_1.TableCell, { colSpan: nbColumns }, (0, react_1.isValidElement)(expand)
                ? expand
                : (0, react_1.createElement)(expand))))));
});
var areEqual = function (prevProps, nextProps) {
    var _1 = prevProps.children, _2 = prevProps.expand, prevPropsWithoutChildren = __rest(prevProps, ["children", "expand"]);
    var _3 = nextProps.children, _4 = nextProps.expand, nextPropsWithoutChildren = __rest(nextProps, ["children", "expand"]);
    return (0, ra_core_1.shallowEqual)(prevPropsWithoutChildren, nextPropsWithoutChildren);
};
exports.PureDatagridRow = (0, react_1.memo)(DatagridRow, areEqual);
exports.PureDatagridRow.displayName = 'PureDatagridRow';
exports.default = DatagridRow;
//# sourceMappingURL=DatagridRow.js.map