"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddSavedQueryDialog = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var ra_core_1 = require("ra-core");
var material_1 = require("@mui/material");
var useSavedQueries_1 = require("./useSavedQueries");
var AddSavedQueryDialog = function (_a) {
    var open = _a.open, onClose = _a.onClose;
    var translate = (0, ra_core_1.useTranslate)();
    var _b = (0, ra_core_1.useListContext)(), resource = _b.resource, filterValues = _b.filterValues, displayedFilters = _b.displayedFilters, sort = _b.sort, perPage = _b.perPage;
    var _c = (0, useSavedQueries_1.useSavedQueries)(resource), savedQueries = _c[0], setSavedQueries = _c[1];
    // input state
    var _d = (0, react_1.useState)(''), queryName = _d[0], setQueryName = _d[1];
    var handleQueryNameChange = function (event) {
        setQueryName(event.target.value);
    };
    var handleFormSubmit = function (e) {
        e.preventDefault();
        addQuery();
    };
    var addQuery = function () {
        var newSavedQuery = {
            label: queryName,
            value: {
                filter: filterValues,
                sort: sort,
                perPage: perPage,
                displayedFilters: displayedFilters,
            },
        };
        var newSavedQueries = (0, useSavedQueries_1.extractValidSavedQueries)(savedQueries);
        setSavedQueries(newSavedQueries.concat(newSavedQuery));
        setQueryName('');
        onClose();
    };
    return (React.createElement(material_1.Dialog, { open: open, onClose: onClose, "aria-labelledby": "form-dialog-title" },
        React.createElement(material_1.DialogTitle, { id: "form-dialog-title" }, translate('ra.saved_queries.new_dialog_title', {
            _: 'Save current query as',
        })),
        React.createElement(material_1.DialogContent, null,
            React.createElement("form", { onSubmit: handleFormSubmit },
                React.createElement(material_1.TextField
                // eslint-disable-next-line jsx-a11y/no-autofocus
                , { 
                    // eslint-disable-next-line jsx-a11y/no-autofocus
                    autoFocus: true, margin: "dense", id: "name", label: translate('ra.saved_queries.query_name', {
                        _: 'Query name',
                    }), fullWidth: true, value: queryName, onChange: handleQueryNameChange }))),
        React.createElement(material_1.DialogActions, null,
            React.createElement(material_1.Button, { onClick: onClose }, translate('ra.action.cancel')),
            React.createElement(material_1.Button, { onClick: addQuery, color: "primary" }, translate('ra.action.save')))));
};
exports.AddSavedQueryDialog = AddSavedQueryDialog;
//# sourceMappingURL=AddSavedQueryDialog.js.map