"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFilterFormValues = exports.FilterFormClasses = exports.mergeInitialValuesWithDefaultValues = exports.FilterFormBase = exports.FilterForm = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var styles_1 = require("@mui/material/styles");
var ra_core_1 = require("ra-core");
var react_hook_form_1 = require("react-hook-form");
var set_1 = __importDefault(require("lodash/set"));
var unset_1 = __importDefault(require("lodash/unset"));
var get_1 = __importDefault(require("lodash/get"));
var cloneDeep_1 = __importDefault(require("lodash/cloneDeep"));
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var FilterFormInput_1 = require("./FilterFormInput");
var FilterContext_1 = require("../FilterContext");
var FilterForm = function (props) {
    var defaultValues = props.defaultValues, filtersProps = props.filters, rest = __rest(props, ["defaultValues", "filters"]);
    var _a = (0, ra_core_1.useListContext)(), setFilters = _a.setFilters, displayedFilters = _a.displayedFilters, filterValues = _a.filterValues;
    var filters = (0, react_1.useContext)(FilterContext_1.FilterContext) || filtersProps;
    var mergedInitialValuesWithDefaultValues = (0, exports.mergeInitialValuesWithDefaultValues)(defaultValues || filterValues, filters);
    var form = (0, react_hook_form_1.useForm)({
        defaultValues: mergedInitialValuesWithDefaultValues,
    });
    var getValues = form.getValues, reset = form.reset, trigger = form.trigger, watch = form.watch;
    // Reapply filterValues when the URL changes or a user removes a filter
    (0, react_1.useEffect)(function () {
        var newValues = (0, exports.getFilterFormValues)(getValues(), filterValues);
        var previousValues = getValues();
        if (!(0, isEqual_1.default)(newValues, previousValues)) {
            reset(newValues);
        }
        // The reference to the filterValues object is not updated when it changes,
        // so we must stringify it to compare it by value and also compare the reference.
        // This makes it work for both input values and filters applied directly through
        // the ListContext.setFilter (e.g. QuickFilter in the simple example)
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [JSON.stringify(filterValues), filterValues, getValues, reset]);
    (0, react_1.useEffect)(function () {
        var subscription = watch(function (values, _a) {
            var name = _a.name;
            return __awaiter(void 0, void 0, void 0, function () {
                var isFormValid, newValues;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0: return [4 /*yield*/, trigger()];
                        case 1:
                            isFormValid = _b.sent();
                            // Check that the name is present to avoid setting filters when watch was
                            // triggered by a change on the ListContext values.
                            if (name && isFormValid) {
                                if ((0, get_1.default)(values, name) === '') {
                                    newValues = (0, cloneDeep_1.default)(values);
                                    (0, unset_1.default)(newValues, name);
                                    setFilters(newValues, displayedFilters, true);
                                }
                                else {
                                    setFilters(values, displayedFilters, true);
                                }
                            }
                            return [2 /*return*/];
                    }
                });
            });
        });
        return function () { return subscription.unsubscribe(); };
    }, [displayedFilters, setFilters, trigger, watch]);
    return (React.createElement(react_hook_form_1.FormProvider, __assign({}, form),
        React.createElement(ra_core_1.FormGroupsProvider, null,
            React.createElement(exports.FilterFormBase, __assign({ onSubmit: handleFormSubmit, filters: filters }, rest)))));
};
exports.FilterForm = FilterForm;
var FilterFormBase = function (props) {
    var className = props.className, filters = props.filters, rest = __rest(props, ["className", "filters"]);
    var resource = (0, ra_core_1.useResourceContext)(props);
    var form = (0, react_hook_form_1.useFormContext)();
    var _a = (0, ra_core_1.useListContext)(), _b = _a.displayedFilters, displayedFilters = _b === void 0 ? {} : _b, hideFilter = _a.hideFilter;
    (0, react_1.useEffect)(function () {
        if (!filters)
            return;
        filters.forEach(function (filter) {
            if (filter.props.alwaysOn && filter.props.defaultValue) {
                throw new Error('Cannot use alwaysOn and defaultValue on a filter input. Please set the filterDefaultValues props on the <List> element instead.');
            }
        });
    }, [filters]);
    var getShownFilters = function () {
        if (!filters)
            return [];
        var values = form.getValues();
        return filters.filter(function (filterElement) {
            var filterValue = (0, get_1.default)(values, filterElement.props.source);
            return (filterElement.props.alwaysOn ||
                displayedFilters[filterElement.props.source] ||
                !isEmptyValue(filterValue));
        });
    };
    var handleHide = (0, react_1.useCallback)(function (event) { return hideFilter(event.currentTarget.dataset.key); }, [hideFilter]);
    var sourceContext = React.useMemo(function () { return ({
        getSource: function (source) { return source; },
        getLabel: function (source) {
            return "resources.".concat(resource, ".fields.").concat(source);
        },
    }); }, [resource]);
    return (React.createElement(ra_core_1.SourceContextProvider, { value: sourceContext },
        React.createElement(StyledForm, __assign({ className: className }, sanitizeRestProps(rest), { onSubmit: handleSubmit }),
            getShownFilters().map(function (filterElement) { return (React.createElement(FilterFormInput_1.FilterFormInput, { key: filterElement.key || filterElement.props.source, filterElement: filterElement, handleHide: handleHide, resource: resource, className: exports.FilterFormClasses.filterFormInput })); }),
            React.createElement("div", { className: exports.FilterFormClasses.clearFix }))));
};
exports.FilterFormBase = FilterFormBase;
var handleSubmit = function (event) {
    event.preventDefault();
    return false;
};
var sanitizeRestProps = function (_a) {
    var hasCreate = _a.hasCreate, resource = _a.resource, props = __rest(_a, ["hasCreate", "resource"]);
    return props;
};
var mergeInitialValuesWithDefaultValues = function (initialValues, filters) { return (__assign(__assign({}, filters
    .filter(function (filterElement) {
    return filterElement.props.alwaysOn && filterElement.props.defaultValue;
})
    .reduce(function (acc, filterElement) {
    return (0, set_1.default)(__assign({}, acc), filterElement.props.source, filterElement.props.defaultValue);
}, {})), initialValues)); };
exports.mergeInitialValuesWithDefaultValues = mergeInitialValuesWithDefaultValues;
var handleFormSubmit = function (event) {
    event.preventDefault();
    event.stopPropagation();
    return false;
};
var PREFIX = 'RaFilterForm';
exports.FilterFormClasses = {
    clearFix: "".concat(PREFIX, "-clearFix"),
    filterFormInput: "".concat(PREFIX, "-filterFormInput"),
};
var StyledForm = (0, styles_1.styled)('form', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flex: '0 1 auto'
        },
        _b[theme.breakpoints.down('sm')] = {
            width: '100%',
        },
        _b[theme.breakpoints.up('sm')] = {
            minHeight: theme.spacing(8),
        },
        _b[theme.breakpoints.up('md')] = {
            flex: '0 1 100%',
        },
        _b.flexWrap = 'wrap',
        _b.alignItems = 'flex-end',
        _b.pointerEvents = 'none',
        _b.padding = "0 0 ".concat(theme.spacing(0.5), " 0"),
        _b['& .MuiFormHelperText-root'] = { display: 'none' },
        _b["& .".concat(exports.FilterFormClasses.clearFix)] = { clear: 'right' },
        _b["& .".concat(exports.FilterFormClasses.filterFormInput, " .MuiFormControl-root")] = {
            marginTop: "".concat(theme.spacing(1)),
        },
        _b);
});
/**
 * Because we are using controlled inputs with react-hook-form, we must provide a default value
 * for each input when resetting the form. (see https://react-hook-form.com/docs/useform/reset).
 * To ensure we don't provide undefined which will result to the current input value being reapplied
 * and due to the dynamic nature of the filter form, we rebuild the filter form values from its current
 * values and make sure to pass at least an empty string for each input.
 */
var getFilterFormValues = function (formValues, filterValues) {
    var _a;
    return Object.keys(formValues).reduce(function (acc, key) {
        acc[key] = getInputValue(formValues, key, filterValues);
        return acc;
    }, (_a = (0, cloneDeep_1.default)(filterValues)) !== null && _a !== void 0 ? _a : {});
};
exports.getFilterFormValues = getFilterFormValues;
var getInputValue = function (formValues, key, filterValues) {
    if (formValues[key] === undefined || formValues[key] === null) {
        return '';
    }
    if (Array.isArray(formValues[key])) {
        return (0, get_1.default)(filterValues, key, '');
    }
    if (formValues[key] instanceof Date) {
        return (0, get_1.default)(filterValues, key, '');
    }
    if (typeof formValues[key] === 'object') {
        var inputValues = Object.keys(formValues[key]).reduce(function (acc, innerKey) {
            var _a;
            var nestedInputValue = getInputValue(formValues[key], innerKey, (_a = (filterValues || {})[key]) !== null && _a !== void 0 ? _a : {});
            acc[innerKey] = nestedInputValue;
            return acc;
        }, {});
        if (!Object.keys(inputValues).length)
            return '';
        return inputValues;
    }
    return (0, get_1.default)(filterValues, key, '');
};
var isEmptyValue = function (filterValue) {
    if (filterValue === '' || filterValue == null)
        return true;
    // If one of the value leaf is not empty
    // the value is considered not empty
    if (typeof filterValue === 'object') {
        return Object.keys(filterValue).every(function (key) {
            return isEmptyValue(filterValue[key]);
        });
    }
    return false;
};
//# sourceMappingURL=FilterForm.js.map