"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveSavedQueryDialog = void 0;
var React = __importStar(require("react"));
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var ra_core_1 = require("ra-core");
var material_1 = require("@mui/material");
var useSavedQueries_1 = require("./useSavedQueries");
var RemoveSavedQueryDialog = function (_a) {
    var open = _a.open, onClose = _a.onClose;
    var translate = (0, ra_core_1.useTranslate)();
    var _b = (0, ra_core_1.useListContext)(), resource = _b.resource, filterValues = _b.filterValues, sort = _b.sort, perPage = _b.perPage, displayedFilters = _b.displayedFilters;
    var _c = (0, useSavedQueries_1.useSavedQueries)(resource), savedQueries = _c[0], setSavedQueries = _c[1];
    var removeQuery = function () {
        var savedQueryToRemove = {
            filter: filterValues,
            sort: sort,
            perPage: perPage,
            displayedFilters: displayedFilters,
        };
        var newSavedQueries = (0, useSavedQueries_1.extractValidSavedQueries)(savedQueries);
        var index = newSavedQueries.findIndex(function (savedFilter) {
            return (0, isEqual_1.default)(savedFilter.value, savedQueryToRemove);
        });
        setSavedQueries(__spreadArray(__spreadArray([], newSavedQueries.slice(0, index), true), newSavedQueries.slice(index + 1), true));
        onClose();
    };
    return (React.createElement(material_1.Dialog, { open: open, onClose: onClose, "aria-labelledby": "alert-dialog-title", "aria-describedby": "alert-dialog-description" },
        React.createElement(material_1.DialogTitle, { id: "alert-dialog-title" }, translate('ra.saved_queries.remove_dialog_title', {
            _: 'Remove saved query?',
        })),
        React.createElement(material_1.DialogContent, null,
            React.createElement(material_1.DialogContentText, null, translate('ra.saved_queries.remove_message', {
                _: 'Are you sure you want to remove that item from your list of saved queries?',
            }))),
        React.createElement(material_1.DialogActions, null,
            React.createElement(material_1.Button, { onClick: onClose }, translate('ra.action.cancel')),
            React.createElement(material_1.Button, { onClick: removeQuery, color: "primary", 
                // eslint-disable-next-line jsx-a11y/no-autofocus
                autoFocus: true }, translate('ra.action.confirm')))));
};
exports.RemoveSavedQueryDialog = RemoveSavedQueryDialog;
//# sourceMappingURL=RemoveSavedQueryDialog.js.map