"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SavedQueriesListClasses = exports.SavedQueriesList = void 0;
var React = __importStar(require("react"));
var material_1 = require("@mui/material");
var BookmarkBorder_1 = __importDefault(require("@mui/icons-material/BookmarkBorder"));
var HelpOutline_1 = __importDefault(require("@mui/icons-material/HelpOutline"));
var ra_core_1 = require("ra-core");
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var useSavedQueries_1 = require("./useSavedQueries");
var RemoveSavedQueryIconButton_1 = require("./RemoveSavedQueryIconButton");
var AddSavedQueryIconButton_1 = require("./AddSavedQueryIconButton");
var SavedQueryFilterListItem_1 = require("./SavedQueryFilterListItem");
var FilterList_1 = require("./FilterList");
/**
 * FilterList-like component allowing to save and restore a query (filters, sort, perPage).
 *
 * Use this component in a Filter sidebar to let users store custom queries
 * that they can reuse later. The saved queries will appear as FilterListItems,
 * and can be removed.
 *
 * This component uses useStore under the hood to store saved queries in
 * localStorage, one set of saved queries per resource.
 *
 * @example
 *
 * import { FilterList, FilterListItem, List, Datagrid, SavedQueriesList } from 'react-admin';
 * import { Card, CardContent } from '@mui/material';
 *
 * const PostFilterSidebar = () => (
 *     <Card>
 *         <CardContent>
 *             <SavedQueriesList />
 *             <FilterList label="Category" icon={<CategoryIcon />}>
 *                 ...
 *             </FilterList>
 *             <FilterList label="Published" icon={<DateRangeIcon />}>
 *                ...
 *             </FilterList>
 *             <FilterList label="Popularity" icon={<DateRangeIcon />}>
 *                ...
 *             </FilterList>
 *         </CardContent>
 *     </Card>
 * );
 *
 * const PostList = () => (
 *     <List aside={<PostFilterSidebar />}>
 *         <Datagrid>
 *             ...
 *         </Datagrid>
 *     </List>
 * );
 *
 */
var SavedQueriesList = function (_a) {
    var _b = _a.icon, icon = _b === void 0 ? defaultIcon : _b;
    var translate = (0, ra_core_1.useTranslate)();
    var _c = (0, ra_core_1.useListContext)(), resource = _c.resource, filterValues = _c.filterValues, displayedFilters = _c.displayedFilters, sort = _c.sort, perPage = _c.perPage;
    var savedQueries = (0, useSavedQueries_1.useSavedQueries)(resource)[0];
    var validSavedQueries = (0, useSavedQueries_1.extractValidSavedQueries)(savedQueries);
    var hasSavedCurrentFilterValue = validSavedQueries.some(function (savedQuery) {
        return (0, isEqual_1.default)(savedQuery.value, {
            filter: filterValues,
            sort: sort,
            perPage: perPage,
            displayedFilters: displayedFilters,
        });
    });
    var hasFilterValues = !(0, isEqual_1.default)(filterValues, {});
    return (React.createElement(Root, { label: "ra.saved_queries.label", icon: icon },
        hasSavedCurrentFilterValue ? (React.createElement(RemoveSavedQueryIconButton_1.RemoveSavedQueryIconButton, { className: exports.SavedQueriesListClasses.floatingIcon })) : hasFilterValues ? (React.createElement(AddSavedQueryIconButton_1.AddSavedQueryIconButton, { className: exports.SavedQueriesListClasses.floatingIcon })) : (React.createElement(material_1.Tooltip, { title: translate('ra.saved_queries.help'), className: exports.SavedQueriesListClasses.floatingTooltip },
            React.createElement(HelpOutline_1.default, null))),
        validSavedQueries.map(function (savedQuery, index) { return (React.createElement(SavedQueryFilterListItem_1.SavedQueryFilterListItem, { label: savedQuery.label, value: savedQuery.value, key: index })); })));
};
exports.SavedQueriesList = SavedQueriesList;
var PREFIX = 'RaSavedQueriesList';
exports.SavedQueriesListClasses = {
    floatingIcon: "".concat(PREFIX, "-floatingIcon"),
    floatingTooltip: "".concat(PREFIX, "-floatingTooltip"),
    titleContainer: "".concat(PREFIX, "-titleContainer"),
    titleIcon: "".concat(PREFIX, "-titleIcon"),
};
var Root = (0, material_1.styled)(FilterList_1.FilterList, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(exports.SavedQueriesListClasses.floatingIcon)] = {
            position: 'absolute',
            top: '-1.8em',
            right: 0,
        },
        _b["& .".concat(exports.SavedQueriesListClasses.floatingTooltip)] = {
            position: 'absolute',
            top: '-1.2em',
            right: 3,
            color: theme.palette.action.disabled,
        },
        _b);
});
var defaultIcon = React.createElement(BookmarkBorder_1.default, null);
//# sourceMappingURL=SavedQueriesList.js.map