"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SavedQueryFilterListItemClasses = exports.SavedQueryFilterListItem = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var material_1 = require("@mui/material");
var CancelOutlined_1 = __importDefault(require("@mui/icons-material/CancelOutlined"));
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var react_router_dom_1 = require("react-router-dom");
var query_string_1 = require("query-string");
var ra_core_1 = require("ra-core");
var arePropsEqual = function (prevProps, nextProps) {
    return prevProps.label === nextProps.label &&
        (0, isEqual_1.default)(prevProps.value, nextProps.value);
};
exports.SavedQueryFilterListItem = (0, react_1.memo)(function (props) {
    var className = props.className, label = props.label, sx = props.sx, value = props.value;
    var _a = (0, ra_core_1.useListContext)(), filterValues = _a.filterValues, sort = _a.sort, perPage = _a.perPage, displayedFilters = _a.displayedFilters;
    var navigate = (0, react_router_dom_1.useNavigate)();
    var isSelected = (0, isEqual_1.default)(value, {
        filter: filterValues,
        sort: sort,
        perPage: perPage,
        displayedFilters: displayedFilters,
    });
    var addFilter = function () {
        var _a, _b, _c;
        navigate({
            search: (0, query_string_1.stringify)({
                filter: JSON.stringify(value.filter),
                sort: (_a = value.sort) === null || _a === void 0 ? void 0 : _a.field,
                order: (_b = value.sort) === null || _b === void 0 ? void 0 : _b.order,
                page: 1,
                perPage: (_c = value.perPage) !== null && _c !== void 0 ? _c : perPage,
                displayedFilters: JSON.stringify(value.displayedFilters),
            }),
        });
    };
    var removeFilter = function () {
        navigate({
            search: (0, query_string_1.stringify)({
                filter: JSON.stringify({}),
            }),
        });
    };
    var toggleFilter = function () {
        return isSelected ? removeFilter() : addFilter();
    };
    return (
    // @ts-ignore
    React.createElement(StyledListItem, { onClick: toggleFilter, selected: isSelected, className: className, sx: sx, disablePadding: true },
        React.createElement(material_1.ListItemButton, { disableGutters: true, className: exports.SavedQueryFilterListItemClasses.listItemButton },
            React.createElement(material_1.ListItemText, { primary: label, className: exports.SavedQueryFilterListItemClasses.listItemText }),
            isSelected && (React.createElement(material_1.ListItemSecondaryAction, null,
                React.createElement(material_1.IconButton, { size: "small", onClick: toggleFilter },
                    React.createElement(CancelOutlined_1.default, null)))))));
}, arePropsEqual);
var PREFIX = 'RaSavedQueryFilterListItem';
exports.SavedQueryFilterListItemClasses = {
    listItemButton: "".concat(PREFIX, "-listItemButton"),
    listItemText: "".concat(PREFIX, "-listItemText"),
};
var StyledListItem = (0, material_1.styled)(material_1.ListItem, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function () {
    var _a;
    return (_a = {},
        _a["& .".concat(exports.SavedQueryFilterListItemClasses.listItemButton)] = {
            paddingRight: '2em',
            paddingLeft: '2em',
        },
        _a["& .".concat(exports.SavedQueryFilterListItemClasses.listItemText)] = {
            margin: 0,
        },
        _a);
});
//# sourceMappingURL=SavedQueryFilterListItem.js.map