"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pagination = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var material_1 = require("@mui/material");
var ra_core_1 = require("ra-core");
var PaginationActions_1 = require("./PaginationActions");
exports.Pagination = (0, react_1.memo)(function (props) {
    var _a = props.rowsPerPageOptions, rowsPerPageOptions = _a === void 0 ? DefaultRowsPerPageOptions : _a, actions = props.actions, _b = props.limit, limit = _b === void 0 ? null : _b, rest = __rest(props, ["rowsPerPageOptions", "actions", "limit"]);
    var _c = (0, ra_core_1.useListPaginationContext)(), isPending = _c.isPending, hasNextPage = _c.hasNextPage, page = _c.page, perPage = _c.perPage, total = _c.total, setPage = _c.setPage, setPerPage = _c.setPerPage;
    var translate = (0, ra_core_1.useTranslate)();
    var isSmall = (0, material_1.useMediaQuery)(function (theme) {
        return theme.breakpoints.down('md');
    });
    var totalPages = (0, react_1.useMemo)(function () {
        return total != null ? Math.ceil(total / perPage) : undefined;
    }, [perPage, total]);
    /**
     * Warning: Material UI's page is 0-based
     */
    var handlePageChange = (0, react_1.useCallback)(function (event, page) {
        event && event.stopPropagation();
        if (page < 0 || (totalPages && page > totalPages - 1)) {
            throw new Error(translate('ra.navigation.page_out_of_boundaries', {
                page: page + 1,
            }));
        }
        setPage(page + 1);
    }, [totalPages, setPage, translate]);
    var handlePerPageChange = (0, react_1.useCallback)(function (event) {
        setPerPage(event.target.value);
    }, [setPerPage]);
    var labelDisplayedRows = (0, react_1.useCallback)(function (_a) {
        var from = _a.from, to = _a.to, count = _a.count;
        return count === -1 && hasNextPage
            ? translate('ra.navigation.partial_page_range_info', {
                offsetBegin: from,
                offsetEnd: to,
                _: "%{from}-%{to} of more than %{to}",
            })
            : translate('ra.navigation.page_range_info', {
                offsetBegin: from,
                offsetEnd: to,
                total: count === -1 ? to : count,
                _: "%{from}-%{to} of %{count === -1 ? to : count}",
            });
    }, [translate, hasNextPage]);
    var labelItem = (0, react_1.useCallback)(function (type) { return translate("ra.navigation.".concat(type), { _: "Go to ".concat(type, " page") }); }, [translate]);
    if (isPending) {
        return React.createElement(material_1.Toolbar, { variant: "dense" });
    }
    // Avoid rendering TablePagination if "page" value is invalid
    if (total === 0 || page < 1 || (total != null && page > totalPages)) {
        if (limit != null && process.env.NODE_ENV === 'development') {
            console.warn('The Pagination limit prop is deprecated. Empty state should be handled by the component displaying data (Datagrid, SimpleList).');
        }
        return null;
    }
    if (isSmall) {
        return (React.createElement(material_1.TablePagination, __assign({ count: total == null ? -1 : total, rowsPerPage: perPage, page: page - 1, onPageChange: handlePageChange, rowsPerPageOptions: emptyArray, component: "span", labelDisplayedRows: labelDisplayedRows }, (0, ra_core_1.sanitizeListRestProps)(rest))));
    }
    var ActionsComponent = actions
        ? actions // overridden by caller
        : !isPending && total != null
            ? PaginationActions_1.PaginationActions // regular navigation
            : undefined; // partial navigation (uses default TablePaginationActions)
    return (React.createElement(material_1.TablePagination, __assign({ count: total == null ? -1 : total, rowsPerPage: perPage, page: page - 1, onPageChange: handlePageChange, onRowsPerPageChange: handlePerPageChange, 
        // @ts-ignore
        ActionsComponent: ActionsComponent, nextIconButtonProps: {
            disabled: !hasNextPage,
        }, component: "span", labelRowsPerPage: translate('ra.navigation.page_rows_per_page'), labelDisplayedRows: labelDisplayedRows, getItemAriaLabel: labelItem, rowsPerPageOptions: rowsPerPageOptions }, (0, ra_core_1.sanitizeListRestProps)(rest))));
});
var DefaultRowsPerPageOptions = [5, 10, 25, 50];
var emptyArray = [];
//# sourceMappingURL=Pagination.js.map