"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FieldsSelector = void 0;
var React = __importStar(require("react"));
var ra_core_1 = require("ra-core");
var material_1 = require("@mui/material");
var FieldToggle_1 = require("./FieldToggle");
/**
 * UI to select / deselect fields, and store the selection in preferences
 */
var FieldsSelector = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'columns' : _b, _c = _a.availableName, availableName = _c === void 0 ? 'availableColumns' : _c;
    var translate = (0, ra_core_1.useTranslate)();
    var _d = (0, ra_core_1.usePreference)(availableName, []), availableFields = _d[0], setAvailableFields = _d[1];
    var omit = (0, ra_core_1.usePreference)('omit', [])[0];
    var _e = (0, ra_core_1.usePreference)(name, availableFields
        .filter(function (field) { return !(omit === null || omit === void 0 ? void 0 : omit.includes(field.source)); })
        .map(function (field) { return field.index; })), fields = _e[0], setFields = _e[1];
    var handleToggle = function (event) {
        if (event.target.checked) {
            // add the column at the right position
            setFields(availableFields
                .filter(function (field) {
                return field.index === event.target.name ||
                    fields.includes(field.index);
            })
                .map(function (field) { return field.index; }));
        }
        else {
            setFields(fields.filter(function (index) { return index !== event.target.name; }));
        }
    };
    var handleMove = function (index1, index2) {
        var index1Pos = availableFields.findIndex(
        // eslint-disable-next-line eqeqeq
        function (field) { return field.index == index1; });
        var index2Pos = availableFields.findIndex(
        // eslint-disable-next-line eqeqeq
        function (field) { return field.index == index2; });
        if (index1Pos === -1 || index2Pos === -1) {
            return;
        }
        var newAvailableFields;
        if (index1Pos > index2Pos) {
            newAvailableFields = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], availableFields.slice(0, index2Pos), true), [
                availableFields[index1Pos]
            ], false), availableFields.slice(index2Pos, index1Pos), true), availableFields.slice(index1Pos + 1), true);
        }
        else {
            newAvailableFields = __spreadArray(__spreadArray(__spreadArray(__spreadArray([], availableFields.slice(0, index1Pos), true), availableFields.slice(index1Pos + 1, index2Pos + 1), true), [
                availableFields[index1Pos]
            ], false), availableFields.slice(index2Pos + 1), true);
        }
        setAvailableFields(newAvailableFields);
        setFields(function (fields) {
            return newAvailableFields
                .filter(function (field) { return fields.includes(field.index); })
                .map(function (field) { return field.index; });
        });
    };
    var handleHideAll = function () {
        setFields([]);
    };
    var handleShowAll = function () {
        setFields(availableFields.map(function (field) { return field.index; }));
    };
    return (React.createElement(material_1.Box, { pt: 0.5 },
        React.createElement(material_1.Box, { component: "ul", sx: { paddingInlineStart: 0, m: 0 } }, availableFields.map(function (field) { return (React.createElement(FieldToggle_1.FieldToggle, { key: field.index, source: field.source, label: field.label, index: field.index, selected: fields.includes(field.index), onToggle: handleToggle, onMove: handleMove })); })),
        React.createElement(material_1.Box, { onDrop: function (e) { return e.preventDefault(); }, display: "flex", justifyContent: "space-between", mx: -0.5, mt: 1 },
            React.createElement(material_1.Button, { size: "small", onClick: handleHideAll }, translate('ra.inspector.hideAll', {
                _: 'Hide All',
            })),
            React.createElement(material_1.Button, { size: "small", onClick: handleShowAll }, translate('ra.inspector.showAll', {
                _: 'Show All',
            })))));
};
exports.FieldsSelector = FieldsSelector;
//# sourceMappingURL=FieldsSelector.js.map