"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InspectorClasses = exports.Inspector = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var ra_core_1 = require("ra-core");
var material_1 = require("@mui/material");
var CancelOutlined_1 = __importDefault(require("@mui/icons-material/CancelOutlined"));
var DeleteOutline_1 = __importDefault(require("@mui/icons-material/DeleteOutline"));
var styles_1 = require("@mui/material/styles");
var InspectorRoot_1 = require("./InspectorRoot");
var Inspector = function () {
    var _a = (0, ra_core_1.usePreferencesEditor)(), isEnabled = _a.isEnabled, disable = _a.disable, title = _a.title, titleOptions = _a.titleOptions, editor = _a.editor, preferenceKey = _a.preferenceKey;
    var isDragging = (0, react_1.useRef)(false);
    var removeItems = (0, ra_core_1.useRemoveItemsFromStore)(preferenceKey);
    var theme = (0, styles_1.useTheme)();
    var translate = (0, ra_core_1.useTranslate)();
    var _b = (0, react_1.useState)(0), version = _b[0], setVersion = _b[1];
    var _c = (0, ra_core_1.useStore)('ra.inspector.position', {
        x: 
        // We want it positioned to the far right of the screen
        (document === null || document === void 0 ? void 0 : document.body.clientWidth) -
            // So we remove its size (see the root css class)
            theme.breakpoints.values.sm / 2 -
            // And add a margin
            8,
        y: 8,
    }), dialogPosition = _c[0], setDialogPosition = _c[1];
    // poor man's drag and drop
    // store click position relative to the dialog position
    var _d = (0, react_1.useState)(), clickPosition = _d[0], setClickPosition = _d[1];
    var handleDragStart = function (e) {
        // exit if the user drags on anything but the title
        var draggedElement = document === null || document === void 0 ? void 0 : document.elementFromPoint(e.clientX, e.clientY);
        if ((draggedElement === null || draggedElement === void 0 ? void 0 : draggedElement.id) !== 'inspector-dialog-title') {
            return;
        }
        isDragging.current = true;
        e.dataTransfer.effectAllowed = 'move';
        e.dataTransfer.setData('inspector', '');
        setTimeout(function () {
            e.target.classList.add('hide');
        }, 0);
        setClickPosition({
            x: e.clientX - dialogPosition.x,
            y: e.clientY - dialogPosition.y,
        });
    };
    var handleDragEnd = function (e) {
        if (isDragging.current && clickPosition) {
            setDialogPosition({
                x: e.clientX - clickPosition.x,
                y: e.clientY - clickPosition.y,
            });
            e.target.classList.remove('hide');
            isDragging.current = false;
        }
    };
    // prevent "back to base" animation when the inspector is dropped
    (0, react_1.useEffect)(function () {
        if (!isEnabled)
            return;
        var handleDragover = function (e) {
            if (e.dataTransfer.types.includes('inspector')) {
                e.preventDefault();
            }
        };
        document === null || document === void 0 ? void 0 : document.addEventListener('dragover', handleDragover);
        return function () {
            document === null || document === void 0 ? void 0 : document.removeEventListener('dragover', handleDragover);
        };
    }, [isEnabled]);
    // make sure that the dialog is always visible, as the stored position may be outside the screen
    (0, react_1.useEffect)(function () {
        if (!isEnabled)
            return;
        var moveInspectorIfOutsideScreen = function () {
            window === null || window === void 0 ? void 0 : window.requestAnimationFrame(function () {
                setDialogPosition(function (position) { return ({
                    x: Math.min(position.x, (document === null || document === void 0 ? void 0 : document.body.clientWidth) -
                        theme.breakpoints.values.sm / 2 -
                        8),
                    y: Math.min(position.y, (window === null || window === void 0 ? void 0 : window.innerHeight) - 50),
                }); });
            });
        };
        moveInspectorIfOutsideScreen();
        window === null || window === void 0 ? void 0 : window.addEventListener('resize', moveInspectorIfOutsideScreen);
        return function () {
            window === null || window === void 0 ? void 0 : window.removeEventListener('resize', moveInspectorIfOutsideScreen);
        };
    }, [isEnabled, setDialogPosition, theme.breakpoints.values.sm]);
    var handleReset = function () {
        removeItems();
        // force redraw of the form to use the default values
        setVersion(function (version) { return version + 1; });
    };
    if (!isEnabled)
        return null;
    return (React.createElement(StyledPaper, { className: exports.InspectorClasses.modal, elevation: 3, draggable: true, onDragStart: handleDragStart, onDragEnd: handleDragEnd, sx: { left: dialogPosition.x, top: dialogPosition.y } },
        React.createElement("div", { className: exports.InspectorClasses.title },
            React.createElement(material_1.Typography, { id: "inspector-dialog-title", variant: "overline", component: "div", py: 1, px: 2, flex: "1" }, title && translate(title, titleOptions)),
            React.createElement("span", { id: "inspector-toolbar" }),
            preferenceKey && (React.createElement(material_1.IconButton, { "aria-label": translate('ra.action.remove'), onClick: handleReset, size: "small" },
                React.createElement(DeleteOutline_1.default, { fontSize: "inherit" }))),
            React.createElement(material_1.IconButton, { "aria-label": translate('ra.action.close'), onClick: disable, size: "small", sx: { mr: 1 } },
                React.createElement(CancelOutlined_1.default, { fontSize: "inherit" }))),
        React.createElement("div", { className: exports.InspectorClasses.content, key: version },
            React.createElement(ra_core_1.PreferenceKeyContextProvider, { value: preferenceKey }, editor || React.createElement(InspectorRoot_1.InspectorRoot, null)))));
};
exports.Inspector = Inspector;
var PREFIX = 'RaInspector';
exports.InspectorClasses = {
    modal: "".concat(PREFIX, "-modal"),
    title: "".concat(PREFIX, "-title"),
    content: "".concat(PREFIX, "-content"),
};
var StyledPaper = (0, styles_1.styled)(material_1.Paper, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            position: 'fixed',
            zIndex: theme.zIndex.modal + 1,
            width: theme.breakpoints.values.sm / 2,
            transition: theme.transitions.create(['height', 'width']),
            '&.hide': {
                display: 'none',
            }
        },
        _b["& .".concat(exports.InspectorClasses.title)] = {
            display: 'flex',
            justifyContent: 'space-between',
            alignItems: 'center',
            cursor: 'move',
        },
        _b["& .".concat(exports.InspectorClasses.content)] = {
            overflowY: 'auto',
            maxHeight: '75vh',
            padding: theme.spacing(2),
            paddingTop: 0,
        },
        _b);
});
exports.Inspector.displayName = 'Inspector';
//# sourceMappingURL=Inspector.js.map