"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultTheme = exports.defaultDarkTheme = exports.defaultLightTheme = void 0;
var utils_1 = require("@mui/utils");
var defaultThemeInvariants = {
    typography: {
        h6: {
            fontWeight: 400,
        },
    },
    sidebar: {
        width: 240,
        closedWidth: 50,
    },
    components: {
        MuiAutocomplete: {
            defaultProps: {
                fullWidth: true,
            },
            variants: [
                {
                    props: {},
                    style: function (_a) {
                        var _b;
                        var theme = _a.theme;
                        return (_b = {},
                            _b[theme.breakpoints.down('sm')] = { width: '100%' },
                            _b);
                    },
                },
            ],
        },
        MuiTextField: {
            defaultProps: {
                variant: 'filled',
                margin: 'dense',
                size: 'small',
                fullWidth: true,
            },
            variants: [
                {
                    props: {},
                    style: function (_a) {
                        var _b;
                        var theme = _a.theme;
                        return (_b = {},
                            _b[theme.breakpoints.down('sm')] = { width: '100%' },
                            _b);
                    },
                },
            ],
        },
        MuiFormControl: {
            defaultProps: {
                variant: 'filled',
                margin: 'dense',
                size: 'small',
                fullWidth: true,
            },
        },
        RaSimpleFormIterator: {
            defaultProps: {
                fullWidth: true,
            },
        },
        RaTranslatableInputs: {
            defaultProps: {
                fullWidth: true,
            },
        },
    },
};
exports.defaultLightTheme = (0, utils_1.deepmerge)(defaultThemeInvariants, {
    palette: {
        background: {
            default: '#fafafb',
        },
        secondary: {
            light: '#6ec6ff',
            main: '#2196f3',
            dark: '#0069c0',
            contrastText: '#fff',
        },
    },
    components: {
        MuiFilledInput: {
            styleOverrides: {
                root: {
                    backgroundColor: 'rgba(0, 0, 0, 0.04)',
                    '&$disabled': {
                        backgroundColor: 'rgba(0, 0, 0, 0.04)',
                    },
                },
            },
        },
    },
});
exports.defaultDarkTheme = (0, utils_1.deepmerge)(defaultThemeInvariants, {
    palette: {
        mode: 'dark',
        primary: {
            main: '#90caf9',
        },
        background: {
            default: '#313131',
        },
    },
});
exports.defaultTheme = exports.defaultLightTheme;
//# sourceMappingURL=defaultTheme.js.map