"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.houseDarkTheme = exports.houseLightTheme = void 0;
var material_1 = require("@mui/material");
/**
 * House: A young and joyful theme.
 *
 * Uses rounded corners, blurry backdrop, large padding, and a bright color palette.
 */
var componentsOverrides = function (theme) { return ({
    MuiBackdrop: {
        styleOverrides: {
            root: {
                backgroundColor: (0, material_1.alpha)((0, material_1.darken)('#000C57', 0.4), 0.2),
                backdropFilter: 'blur(2px)',
                '&.MuiBackdrop-invisible': {
                    backgroundColor: 'transparent',
                    backdropFilter: 'blur(2px)',
                },
            },
        },
    },
    MuiAutocomplete: {
        defaultProps: {
            fullWidth: true,
        },
    },
    MuiFormControl: {
        defaultProps: {
            margin: 'dense',
            fullWidth: true,
        },
    },
    MuiOutlinedInput: {
        styleOverrides: {
            input: {
                padding: "".concat(theme.spacing(1), " ").concat(theme.spacing(2)),
            },
        },
    },
    MuiTab: {
        styleOverrides: {
            root: {
                padding: 0,
                height: 38,
                minHeight: 38,
                borderRadius: 6,
                transition: 'color .2s',
                '&.MuiButtonBase-root': {
                    minWidth: 'auto',
                    paddingLeft: 20,
                    paddingRight: 20,
                    marginRight: 4,
                },
                '&.Mui-selected, &.Mui-selected:hover': {
                    color: theme.palette.primary.contrastText,
                    zIndex: 5,
                },
                '&:hover': {
                    color: theme.palette.primary.main,
                },
            },
        },
    },
    MuiTableRow: {
        styleOverrides: {
            root: {
                '&:last-child td': { border: 0 },
            },
        },
    },
    MuiTableCell: {
        styleOverrides: {
            root: {
                padding: theme.spacing(2),
                '&.MuiTableCell-sizeSmall': {
                    padding: theme.spacing(1.5),
                },
                '&.MuiTableCell-paddingNone': {
                    padding: theme.spacing(0.5),
                },
            },
        },
    },
    MuiTabs: {
        styleOverrides: {
            root: {
                height: 38,
                minHeight: 38,
                overflow: 'visible',
            },
            indicator: {
                height: 38,
                minHeight: 38,
                borderRadius: 6,
                border: "1px solid ".concat(theme.palette.primary.light),
                boxShadow: theme.shadows[1],
            },
            scrollableX: {
                overflow: 'visible !important',
            },
        },
    },
    MuiTextField: {
        defaultProps: {
            variant: 'outlined',
            fullWidth: true,
        },
    },
    RaAppBar: {
        styleOverrides: {
            root: {
                color: theme.palette.text.primary,
                '& .RaAppBar-toolbar': {
                    backgroundColor: theme.palette.primary.main,
                    color: theme.palette.background.default,
                    backgroundImage: "linear-gradient(310deg, ".concat(theme.palette.primary.light, ", ").concat(theme.palette.secondary.main, ")"),
                },
            },
        },
    },
    RaMenuItemLink: {
        styleOverrides: {
            root: {
                padding: 10,
                marginRight: 10,
                marginLeft: 10,
                '&:hover': {
                    borderRadius: 5,
                },
                '&.RaMenuItemLink-active': {
                    borderRadius: 10,
                    backgroundColor: theme.palette.common.white,
                    color: theme.palette.primary.main,
                    '&:before': {
                        content: '""',
                        position: 'absolute',
                        top: '0; right: 0; bottom: 0; left: 0',
                        zIndex: '-1',
                        margin: '-2px',
                        borderRadius: '12px',
                        background: "linear-gradient(310deg, ".concat(theme.palette.primary.light, ", ").concat(theme.palette.secondary.main, ")"),
                    },
                    '& .MuiSvgIcon-root': {
                        fill: theme.palette.primary.main,
                    },
                },
            },
        },
    },
    RaSimpleFormIterator: {
        defaultProps: {
            fullWidth: true,
        },
    },
    RaTranslatableInputs: {
        defaultProps: {
            fullWidth: true,
        },
    },
}); };
var alert = {
    error: { main: '#DB488B' },
    warning: { main: '#8C701B' },
    info: { main: '#3ED0EB' },
    success: { main: '#0FBF9F' },
};
var darkPalette = __assign(__assign({ primary: { main: '#ec7a77', light: '#fbcf33' }, background: { default: '#363D40', paper: '#2B3033' } }, alert), { mode: 'dark' });
var lightPalette = __assign(__assign({ primary: { main: '#344767', light: '#7928ca' }, secondary: { main: '#f90283' }, background: { default: '#f7f8f9', paper: '#ffffff' } }, alert), { mode: 'light' });
var createHouseTheme = function (palette) {
    var themeOptions = {
        palette: palette,
        shape: { borderRadius: 20 },
        sidebar: { width: 250 },
        spacing: 9,
        typography: { fontFamily: "'Open Sans', sans-serif" },
    };
    var theme = (0, material_1.createTheme)(themeOptions);
    theme.components = componentsOverrides(theme);
    return theme;
};
exports.houseLightTheme = createHouseTheme(lightPalette);
exports.houseDarkTheme = createHouseTheme(darkPalette);
//# sourceMappingURL=houseTheme.js.map