import { ThemeType } from './types';
export type ThemeSetter = (theme: ThemeType) => void;
/**
 * Read and update the theme mode (light or dark)
 *
 * @example
 * const [theme, setTheme] = useTheme('light');
 * const toggleTheme = () => {
 *    setTheme(theme === 'light' ? 'dark' : 'light');
 * };
 *
 */
export declare const useTheme: (type?: ThemeType) => [ThemeType, ThemeSetter];
//# sourceMappingURL=useTheme.d.ts.map