"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTheme = void 0;
var ra_core_1 = require("ra-core");
var material_1 = require("@mui/material");
var useThemesContext_1 = require("./useThemesContext");
/**
 * Read and update the theme mode (light or dark)
 *
 * @example
 * const [theme, setTheme] = useTheme('light');
 * const toggleTheme = () => {
 *    setTheme(theme === 'light' ? 'dark' : 'light');
 * };
 *
 */
var useTheme = function (type) {
    var darkTheme = (0, useThemesContext_1.useThemesContext)().darkTheme;
    var prefersDarkMode = (0, material_1.useMediaQuery)('(prefers-color-scheme: dark)', {
        noSsr: true,
    });
    var _a = (0, ra_core_1.useStore)('theme', type !== null && type !== void 0 ? type : (prefersDarkMode && darkTheme ? 'dark' : 'light')), theme = _a[0], setter = _a[1];
    // Ensure that even though the store has its value set to 'dark', we still use the light theme when no dark theme is available
    return [darkTheme != null ? theme : 'light', setter];
};
exports.useTheme = useTheme;
//# sourceMappingURL=useTheme.js.map