"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useThemesContext = void 0;
var react_1 = require("react");
var ThemesContext_1 = require("./ThemesContext");
var useThemesContext = function (params) {
    var _a = params || {}, lightTheme = _a.lightTheme, darkTheme = _a.darkTheme, defaultTheme = _a.defaultTheme;
    var context = (0, react_1.useContext)(ThemesContext_1.ThemesContext);
    return {
        lightTheme: lightTheme || context.lightTheme,
        darkTheme: darkTheme || context.darkTheme,
        defaultTheme: defaultTheme !== null && defaultTheme !== void 0 ? defaultTheme : context.defaultTheme,
    };
};
exports.useThemesContext = useThemesContext;
//# sourceMappingURL=useThemesContext.js.map