var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material';
import LockIcon from '@mui/icons-material/Lock';
import { useTranslate } from 'ra-core';
import { Button } from '../button';
import { Link } from 'react-router-dom';
export var AuthError = function (props) {
    var className = props.className, _a = props.title, title = _a === void 0 ? 'ra.page.error' : _a, _b = props.message, message = _b === void 0 ? 'ra.message.auth_error' : _b, rest = __rest(props, ["className", "title", "message"]);
    var translate = useTranslate();
    return (React.createElement(Root, __assign({ className: className }, rest),
        React.createElement("div", { className: AuthErrorClasses.message },
            React.createElement("h1", null, translate(title, { _: title })),
            React.createElement("div", null, translate(message, { _: message })),
            React.createElement(Button, { component: Link, to: "/login", label: "ra.auth.sign_in" },
                React.createElement(LockIcon, null)))));
};
var PREFIX = 'RaAuthError';
export var AuthErrorClasses = {
    root: "".concat(PREFIX, "-root"),
    message: "".concat(PREFIX, "-message"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'center'
        },
        _b[theme.breakpoints.up('md')] = {
            height: '100%',
        },
        _b[theme.breakpoints.down('xl')] = {
            height: '100vh',
            marginTop: '-3em',
        },
        _b["& .".concat(AuthErrorClasses.message)] = {
            textAlign: 'center',
            fontFamily: 'Roboto, sans-serif',
            opacity: 0.5,
            margin: '0 1em',
        },
        _b);
});
//# sourceMappingURL=AuthError.js.map