import * as React from 'react';
import { BulkDeleteWithConfirmButtonProps } from './BulkDeleteWithConfirmButton';
import { BulkDeleteWithUndoButtonProps } from './BulkDeleteWithUndoButton';
import { MutationMode } from 'ra-core';
/**
 * Deletes the selected rows.
 *
 * To be used inside the <Datagrid bulkActionButtons> prop (where it's enabled by default).
 *
 * @example // basic usage
 * import { BulkDeleteButton, BulkExportButton, List, Datagrid } from 'react-admin';
 *
 * const PostBulkActionButtons = () => (
 *     <>
 *         <BulkExportButton />
 *         <BulkDeleteButton />
 *     </>
 * );
 *
 * export const PostList = () => (
 *     <List>
 *        <Datagrid bulkActionButtons={<PostBulkActionButtons />}>
 *             ...
 *       </Datagrid>
 *     </List>
 * );
 */
export declare const BulkDeleteButton: ({ mutationMode, ...props }: BulkDeleteButtonProps) => React.JSX.Element | null;
interface Props {
    mutationMode?: MutationMode;
}
export type BulkDeleteButtonProps = Props & (BulkDeleteWithUndoButtonProps | BulkDeleteWithConfirmButtonProps);
export {};
//# sourceMappingURL=BulkDeleteButton.d.ts.map