var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { BulkDeleteWithConfirmButton, } from './BulkDeleteWithConfirmButton';
import { BulkDeleteWithUndoButton, } from './BulkDeleteWithUndoButton';
import { useCanAccess, useResourceContext } from 'ra-core';
/**
 * Deletes the selected rows.
 *
 * To be used inside the <Datagrid bulkActionButtons> prop (where it's enabled by default).
 *
 * @example // basic usage
 * import { BulkDeleteButton, BulkExportButton, List, Datagrid } from 'react-admin';
 *
 * const PostBulkActionButtons = () => (
 *     <>
 *         <BulkExportButton />
 *         <BulkDeleteButton />
 *     </>
 * );
 *
 * export const PostList = () => (
 *     <List>
 *        <Datagrid bulkActionButtons={<PostBulkActionButtons />}>
 *             ...
 *       </Datagrid>
 *     </List>
 * );
 */
export var BulkDeleteButton = function (_a) {
    var _b = _a.mutationMode, mutationMode = _b === void 0 ? 'undoable' : _b, props = __rest(_a, ["mutationMode"]);
    var resource = useResourceContext(props);
    if (!resource) {
        throw new Error('<BulkDeleteButton> components should be used inside a <Resource> component or provided with a resource prop.');
    }
    var _c = useCanAccess({
        action: 'delete',
        resource: resource,
    }), canAccess = _c.canAccess, isPending = _c.isPending;
    if (!canAccess || isPending) {
        return null;
    }
    return mutationMode === 'undoable' ? (React.createElement(BulkDeleteWithUndoButton, __assign({}, props))) : (React.createElement(BulkDeleteWithConfirmButton, __assign({ mutationMode: mutationMode }, props)));
};
//# sourceMappingURL=BulkDeleteButton.js.map