var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useCallback } from 'react';
import DownloadIcon from '@mui/icons-material/GetApp';
import { fetchRelatedRecords, useDataProvider, useNotify, useListContext, useResourceContext, } from 'ra-core';
import { Button } from './Button';
/**
 * Export the selected rows
 *
 * To be used inside the <Datagrid bulkActionButtons> prop.
 *
 * @example // basic usage
 * import { BulkDeleteButton, BulkExportButton, List, Datagrid } from 'react-admin';
 *
 * const PostBulkActionButtons = () => (
 *     <>
 *         <BulkExportButton />
 *         <BulkDeleteButton />
 *     </>
 * );
 *
 * export const PostList = () => (
 *     <List>
 *        <Datagrid bulkActionButtons={<PostBulkActionButtons />}>
 *          ...
 *       </Datagrid>
 *     </List>
 * );
 */
export var BulkExportButton = function (props) {
    var onClick = props.onClick, _a = props.label, label = _a === void 0 ? 'ra.action.export' : _a, _b = props.icon, icon = _b === void 0 ? defaultIcon : _b, customExporter = props.exporter, meta = props.meta, rest = __rest(props, ["onClick", "label", "icon", "exporter", "meta"]);
    var resource = useResourceContext(props);
    var _c = useListContext(), exporterFromContext = _c.exporter, selectedIds = _c.selectedIds;
    var exporter = customExporter || exporterFromContext;
    var dataProvider = useDataProvider();
    var notify = useNotify();
    var handleClick = useCallback(function (event) {
        if (exporter && resource) {
            dataProvider
                .getMany(resource, { ids: selectedIds, meta: meta })
                .then(function (_a) {
                var data = _a.data;
                return exporter(data, fetchRelatedRecords(dataProvider), dataProvider, resource);
            })
                .catch(function (error) {
                console.error(error);
                notify('ra.notification.http_error', {
                    type: 'error',
                });
            });
        }
        if (typeof onClick === 'function') {
            onClick(event);
        }
    }, [dataProvider, exporter, notify, onClick, resource, selectedIds, meta]);
    return (React.createElement(Button, __assign({ onClick: handleClick, label: label }, sanitizeRestProps(rest)), icon));
};
var defaultIcon = React.createElement(DownloadIcon, null);
var sanitizeRestProps = function (_a) {
    var resource = _a.resource, rest = __rest(_a, ["resource"]);
    return rest;
};
//# sourceMappingURL=BulkExportButton.js.map