import * as React from 'react';
import { BulkUpdateWithConfirmButtonProps } from './BulkUpdateWithConfirmButton';
import { BulkUpdateWithUndoButtonProps } from './BulkUpdateWithUndoButton';
import { MutationMode } from 'ra-core';
/**
 * Updates the selected rows.
 *
 * To be used inside the <Datagrid bulkActionButtons> prop (where it's enabled by default).
 *
 * @example // basic usage
 * import { BulkUpdateButton, BulkExportButton, List, Datagrid } from 'react-admin';
 *
 * const PostBulkActionButtons = () => (
 *     <>
 *         <BulkExportButton />
 *         <BulkUpdateButton label="Reset Views" data={{ views: 0 }} />
 *     </>
 * );
 *
 * export const PostList = () => (
 *     <List>
 *        <Datagrid bulkActionButtons={<PostBulkActionButtons />}>
 *          ...
 *        </Datagrid>
 *     </List>
 * );
 */
export declare const BulkUpdateButton: (props: BulkUpdateButtonProps) => React.JSX.Element;
interface Props {
    mutationMode?: MutationMode;
}
export type BulkUpdateButtonProps = Props & (BulkUpdateWithUndoButtonProps | BulkUpdateWithConfirmButtonProps);
export {};
//# sourceMappingURL=BulkUpdateButton.d.ts.map