var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { memo } from 'react';
import Queue from '@mui/icons-material/Queue';
import { Link } from 'react-router-dom';
import { stringify } from 'query-string';
import { useResourceContext, useRecordContext, useCreatePath } from 'ra-core';
import { Button } from './Button';
export var CloneButton = function (props) {
    var _a = props.label, label = _a === void 0 ? 'ra.action.clone' : _a, _b = props.scrollToTop, scrollToTop = _b === void 0 ? true : _b, _c = props.icon, icon = _c === void 0 ? defaultIcon : _c, rest = __rest(props, ["label", "scrollToTop", "icon"]);
    var resource = useResourceContext(props);
    var record = useRecordContext(props);
    var createPath = useCreatePath();
    var pathname = createPath({ resource: resource, type: 'create' });
    return (React.createElement(Button, __assign({ component: Link, to: record
            ? {
                pathname: pathname,
                search: stringify({
                    source: JSON.stringify(omitId(record)),
                }),
            }
            : pathname, state: { _scrollToTop: scrollToTop }, label: label, onClick: stopPropagation }, sanitizeRestProps(rest)), icon));
};
var defaultIcon = React.createElement(Queue, null);
// useful to prevent click bubbling in a datagrid with rowClick
var stopPropagation = function (e) { return e.stopPropagation(); };
var omitId = function (_a) {
    var id = _a.id, rest = __rest(_a, ["id"]);
    return rest;
};
var sanitizeRestProps = function (_a) {
    var resource = _a.resource, record = _a.record, rest = __rest(_a, ["resource", "record"]);
    return rest;
};
export default memo(CloneButton);
//# sourceMappingURL=CloneButton.js.map