var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import ContentAdd from '@mui/icons-material/Add';
import { Fab, useMediaQuery } from '@mui/material';
import { styled } from '@mui/material/styles';
import clsx from 'clsx';
import isEqual from 'lodash/isEqual';
import merge from 'lodash/merge';
import { useTranslate, useResourceContext, useCreatePath, useCanAccess, } from 'ra-core';
import { Link } from 'react-router-dom';
import { Button } from './Button';
/**
 * Opens the Create view of a given resource
 *
 * Renders as a regular button on desktop, and a Floating Action Button
 * on mobile.
 *
 * @example // basic usage
 * import { CreateButton } from 'react-admin';
 *
 * const CommentCreateButton = () => (
 *     <CreateButton label="Create comment" />
 * );
 */
var CreateButton = function (props) {
    var className = props.className, _a = props.icon, icon = _a === void 0 ? defaultIcon : _a, _b = props.label, label = _b === void 0 ? 'ra.action.create' : _b, resourceProp = props.resource, _c = props.scrollToTop, scrollToTop = _c === void 0 ? true : _c, variant = props.variant, locationDescriptor = props.to, _d = props.state, initialState = _d === void 0 ? {} : _d, rest = __rest(props, ["className", "icon", "label", "resource", "scrollToTop", "variant", "to", "state"]);
    var resource = useResourceContext(props);
    if (!resource) {
        throw new Error('<CreateButton> components should be used inside a <Resource> component or provided the resource prop.');
    }
    var _e = useCanAccess({
        action: 'create',
        resource: resource,
    }), canAccess = _e.canAccess, isPending = _e.isPending;
    var createPath = useCreatePath();
    var translate = useTranslate();
    var isSmall = useMediaQuery(function (theme) {
        return theme.breakpoints.down('md');
    });
    var state = merge({}, scrollStates.get(String(scrollToTop)), initialState);
    // Duplicated behavior of Button component (legacy use) which will be removed in v5.
    var linkParams = getLinkParams(locationDescriptor);
    if (!canAccess || isPending) {
        return null;
    }
    return isSmall ? (React.createElement(StyledFab, __assign({ component: Link, to: createPath({ resource: resource, type: 'create' }), state: state, 
        // @ts-ignore FabProps ships its own runtime palette `FabPropsColorOverrides` provoking an overlap error with `ButtonProps`
        color: "primary", className: clsx(CreateButtonClasses.floating, className), "aria-label": label && translate(label) }, rest, linkParams), icon)) : (React.createElement(StyledButton, __assign({ component: Link, to: createPath({ resource: resource, type: 'create' }), state: state, className: clsx(CreateButtonClasses.root, className), label: label, variant: variant }, rest, linkParams), icon));
};
// avoids using useMemo to get a constant value for the link state
var scrollStates = new Map([
    ['true', { _scrollToTop: true }],
    ['false', {}],
]);
var defaultIcon = React.createElement(ContentAdd, null);
var PREFIX = 'RaCreateButton';
export var CreateButtonClasses = {
    root: "".concat(PREFIX, "-root"),
    floating: "".concat(PREFIX, "-floating"),
};
var StyledFab = styled(Fab, {
    name: PREFIX,
    overridesResolver: function (_props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {},
        _b["&.".concat(CreateButtonClasses.floating)] = {
            color: theme.palette.getContrastText(theme.palette.primary.main),
            margin: 0,
            top: 'auto',
            right: 20,
            bottom: 60,
            left: 'auto',
            position: 'fixed',
            zIndex: 1000,
        },
        _b);
});
var StyledButton = styled(Button, {
    name: PREFIX,
    overridesResolver: function (_props, styles) { return styles.root; },
})({});
export default React.memo(CreateButton, function (prevProps, nextProps) {
    return (prevProps.resource === nextProps.resource &&
        prevProps.label === nextProps.label &&
        prevProps.translate === nextProps.translate &&
        prevProps.disabled === nextProps.disabled &&
        isEqual(prevProps.to, nextProps.to) &&
        isEqual(prevProps.state, nextProps.state));
});
var getLinkParams = function (locationDescriptor) {
    // eslint-disable-next-line
    if (locationDescriptor == undefined) {
        return undefined;
    }
    if (typeof locationDescriptor === 'string') {
        return { to: locationDescriptor };
    }
    var redirect = locationDescriptor.redirect, replace = locationDescriptor.replace, state = locationDescriptor.state, to = __rest(locationDescriptor, ["redirect", "replace", "state"]);
    return {
        to: to,
        redirect: redirect,
        replace: replace,
        state: state,
    };
};
//# sourceMappingURL=CreateButton.js.map