import * as React from 'react';
import { ReactNode } from 'react';
/**
 * Language selector. Changes the locale in the app and persists it in
 * preferences so that the app opens with the right locale in the future.
 *
 * Uses i18nProvider.getLocales() to get the list of available locales.
 *
 * @example
 * import { AppBar, TitlePortal, LocalesMenuButton } from 'react-admin';
 *
 * const MyAppBar = () => (
 *     <AppBar>
 *         <TitlePortal />
 *         <LocalesMenuButton />
 *     </AppBar>
 * );
 */
export declare const LocalesMenuButton: (props: LocalesMenuButtonProps) => React.JSX.Element;
export declare const LocalesMenuButtonClasses: {};
export interface LocalesMenuButtonProps {
    icon?: ReactNode;
    languages?: {
        locale: string;
        name: string;
    }[];
}
//# sourceMappingURL=LocalesMenuButton.d.ts.map