import * as React from 'react';
import { useTranslate, usePrevNextController, } from 'ra-core';
import NavigateBefore from '@mui/icons-material/NavigateBefore';
import NavigateNext from '@mui/icons-material/NavigateNext';
import ErrorIcon from '@mui/icons-material/Error';
import { Link } from 'react-router-dom';
import { Box, Stack, Typography, IconButton, styled, } from '@mui/material';
import clsx from 'clsx';
import { LinearProgress } from '../layout/LinearProgress';
/**
 * A component used to render the previous and next buttons in a Show or Edit view.
 *
 * The `<PrevNextButtons>` component renders navigation buttons linking to
 * the next and previous records of the current resource, the current index
 * and the total number of records.
 *
 * It uses usePrevNextController to fetch the list of records.
 *
 * `<PrevNextButtons>` can be used anywhere a record context is provided
 * (often inside a `<Show>` or `<Edit>` component).
 *
 * @example <caption>navigate to edit view by default</caption>
 * <ShowButton />
 *
 * @example <caption>navigate to show view</caption>
 * <PrevNextButtons linkType="show" />
 *
 * @example <caption>custom storeKey</caption>
 * <PrevNextButtons storeKey="listStoreKey" />
 *
 * @example <caption>limit the number of records to fetch</caption>
 * <PrevNextButtons limit={500} />
 *
 * @example <caption>customize filters and sort order</caption>
 * <PrevNextButtons
 *     linkType="show"
 *     sort={{
 *         field: 'first_name',
 *         order: 'DESC',
 *     }}
 *     filter={{ q: 'East a' }}
 * />
 *
 * @example <caption>customize style</caption>
 * <PrevNextButtons
 *     sx={{
 *         color: 'blue',
 *         '& .RaPrevNextButton-list': {
 *             marginBottom: '20px',
 *             color: 'red',
 *         },
 *     }}
 * />
 *
 * @example <caption>in an edit view</caption>
 * import * as React from "react";
 * import { Edit, PrevNextButtons, ShowButton, SimpleForm, TopToolbar } from 'react-admin';
 *
 * const MyTopToolbar = ({ children }) => (
 *     <TopToolbar>
 *         {children}
 *     </TopToolbar>
 * );
 *
 * export const PostEdit = () => (
 *      <Edit
 *          actions={
 *              <MyTopToolbar>
 *                  <PrevNextButtons
 *                      sort={{
 *                          field: 'first_name',
 *                          order: 'DESC',
 *                      }}
 *                      filter={{ q: 'East a' }}
 *                  />
 *                  <ShowButton />
 *              </MyTopToolbar>
 *          }
 *      >
 *          <SimpleForm>...</SimpleForm>
 *      </Edit>
 * );
 */
export var PrevNextButtons = function (props) {
    var sx = props.sx;
    var _a = usePrevNextController(props), hasPrev = _a.hasPrev, hasNext = _a.hasNext, prevPath = _a.prevPath, nextPath = _a.nextPath, index = _a.index, total = _a.total, error = _a.error, isPending = _a.isPending;
    var translate = useTranslate();
    if (isPending) {
        return (React.createElement(Box, { minHeight: 34, display: "flex", alignItems: "center" },
            React.createElement(LinearProgress, null)));
    }
    if (error) {
        return (React.createElement(ErrorIcon, { color: "error", fontSize: "small", titleAccess: "error", "aria-errormessage": error.message }));
    }
    if (!hasPrev && !hasNext) {
        return React.createElement(Box, { minHeight: 34 });
    }
    return (React.createElement(Root, { sx: sx, role: "navigation", direction: "row", className: clsx(PrevNextButtonClasses.root) },
        hasPrev && prevPath ? (React.createElement(IconButton, { component: Link, to: prevPath, "aria-label": translate('ra.navigation.previous'), size: "small" },
            React.createElement(NavigateBefore, null))) : (React.createElement(IconButton, { "aria-label": translate('ra.navigation.previous'), disabled: true, size: "small" },
            React.createElement(NavigateBefore, null))),
        typeof index === 'number' && (React.createElement(Typography, { variant: "body2" },
            index + 1,
            " / ",
            total)),
        hasNext && nextPath ? (React.createElement(IconButton, { component: Link, to: nextPath, "aria-label": translate('ra.navigation.next'), size: "small" },
            React.createElement(NavigateNext, null))) : (React.createElement(IconButton, { "aria-label": translate('ra.navigation.next'), disabled: true, size: "small" },
            React.createElement(NavigateNext, null)))));
};
var PREFIX = 'RaPrevNextButton';
export var PrevNextButtonClasses = {
    root: "".concat(PREFIX, "-root"),
};
var Root = styled(Stack, {
    name: PREFIX,
    overridesResolver: function (_props, styles) { return styles.root; },
})({
    display: 'inline-flex',
    alignItems: 'center',
    gap: '0.5em',
});
//# sourceMappingURL=PrevNextButtons.js.map