import * as React from 'react';
import { UpdateWithConfirmButtonProps } from './UpdateWithConfirmButton';
import { UpdateWithUndoButtonProps } from './UpdateWithUndoButton';
/**
 * Updates the current record.
 *
 * To be used inside the <Edit actions> prop or <Show actions> prop.
 *
 * @example // basic usage
 * import * as React from 'react';
 * import { Edit, TopToolbar, UpdateButton } from 'react-admin';
 *
 * const PostEditActions = () => (
 *     <TopToolbar>
 *         <UpdateButton label="Reset Views" data={{ views: 0 }} />
 *     </TopToolbar>
 * );
 *
 * export const PostEdit = () => (
 *     <Edit actions={<PostEditActions />}>
 *         ...
 *     </Edit>
 * );
 */
export declare const UpdateButton: (props: UpdateButtonProps) => React.JSX.Element;
export type UpdateButtonProps = ({
    mutationMode?: 'undoable';
} & UpdateWithUndoButtonProps) | ({
    mutationMode?: 'pessimistic' | 'optimistic';
} & UpdateWithConfirmButtonProps);
//# sourceMappingURL=UpdateButton.d.ts.map