var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { UpdateWithConfirmButton, } from './UpdateWithConfirmButton';
import { UpdateWithUndoButton, } from './UpdateWithUndoButton';
/**
 * Updates the current record.
 *
 * To be used inside the <Edit actions> prop or <Show actions> prop.
 *
 * @example // basic usage
 * import * as React from 'react';
 * import { Edit, TopToolbar, UpdateButton } from 'react-admin';
 *
 * const PostEditActions = () => (
 *     <TopToolbar>
 *         <UpdateButton label="Reset Views" data={{ views: 0 }} />
 *     </TopToolbar>
 * );
 *
 * export const PostEdit = () => (
 *     <Edit actions={<PostEditActions />}>
 *         ...
 *     </Edit>
 * );
 */
export var UpdateButton = function (props) {
    var _a = props.mutationMode, mutationMode = _a === void 0 ? 'undoable' : _a, rest = __rest(props, ["mutationMode"]);
    return mutationMode === 'undoable' ? (React.createElement(UpdateWithUndoButton, __assign({}, rest))) : (React.createElement(UpdateWithConfirmButton, __assign({ mutationMode: mutationMode }, rest)));
};
//# sourceMappingURL=UpdateButton.js.map