var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { Card, styled } from '@mui/material';
import { useCreateContext } from 'ra-core';
import clsx from 'clsx';
import { Title } from '../layout';
export var CreateView = function (props) {
    var _a;
    var actions = props.actions, aside = props.aside, children = props.children, className = props.className, _b = props.component, Content = _b === void 0 ? Card : _b, title = props.title, rest = __rest(props, ["actions", "aside", "children", "className", "component", "title"]);
    var _c = useCreateContext(), resource = _c.resource, defaultTitle = _c.defaultTitle;
    return (React.createElement(Root, __assign({ className: clsx('create-page', className) }, rest),
        title !== false && (React.createElement(Title, { title: title, defaultTitle: defaultTitle, preferenceKey: "".concat(resource, ".create.title") })),
        actions,
        React.createElement("div", { className: clsx(CreateClasses.main, (_a = {},
                _a[CreateClasses.noActions] = !actions,
                _a)) },
            React.createElement(Content, { className: CreateClasses.card }, children),
            aside)));
};
var PREFIX = 'RaCreate';
export var CreateClasses = {
    main: "".concat(PREFIX, "-main"),
    noActions: "".concat(PREFIX, "-noActions"),
    card: "".concat(PREFIX, "-card"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b, _c;
    var theme = _a.theme;
    return (_b = {},
        _b["& .".concat(CreateClasses.main)] = {
            display: 'flex',
        },
        _b["& .".concat(CreateClasses.noActions)] = (_c = {},
            _c[theme.breakpoints.up('sm')] = {
                marginTop: '1em',
            },
            _c),
        _b["& .".concat(CreateClasses.card)] = {
            flex: '1 1 auto',
        },
        _b);
});
//# sourceMappingURL=CreateView.js.map