import * as React from 'react';
import { RaRecord, EditBaseProps } from 'ra-core';
import { EditViewProps } from './EditView';
/**
 * Page component for the Edit view
 *
 * The `<Edit>` component renders the page title and actions,
 * fetches the record from the data provider.
 * It is not responsible for rendering the actual form -
 * that's the job of its child component (usually `<SimpleForm>`),
 * to which it passes the `record` as prop.
 *
 * The <Edit> component accepts the following props:
 *
 * - actions
 * - aside
 * - component
 * - title
 * - mutationMode
 * - mutationOptions
 *
 * @example
 *
 * // in src/posts.js
 * import * as React from "react";
 * import { Edit, SimpleForm, TextInput } from 'react-admin';
 *
 * export const PostEdit = () => (
 *     <Edit>
 *         <SimpleForm>
 *             <TextInput source="title" />
 *         </SimpleForm>
 *     </Edit>
 * );
 *
 * // in src/App.js
 * import * as React from "react";
 * import { Admin, Resource } from 'react-admin';
 *
 * import { PostEdit } from './posts';
 *
 * const App = () => (
 *     <Admin dataProvider={...}>
 *         <Resource name="posts" edit={PostEdit} />
 *     </Admin>
 * );
 * export default App;
 */
export declare const Edit: <RecordType extends RaRecord<import("ra-core").Identifier> = any>(props: EditProps<RecordType, Error>) => React.JSX.Element;
export interface EditProps<RecordType extends RaRecord = any, ErrorType = Error> extends EditBaseProps<RecordType, ErrorType>, Omit<EditViewProps, 'children'> {
}
//# sourceMappingURL=Edit.d.ts.map