var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { Children, isValidElement } from 'react';
import { styled } from '@mui/material/styles';
import { Stack } from '@mui/material';
import clsx from 'clsx';
import { useRecordContext, OptionalRecordContextProvider, } from 'ra-core';
import { Labeled } from '../Labeled';
/**
 * Layout for a Show view showing fields in one column.
 *
 * It pulls the record from the RecordContext. It renders the record fields in
 * a single-column layout (via Material UI's `<Stack>` component).
 * `<SimpleShowLayout>` delegates the actual rendering of fields to its children.
 * It wraps each field inside a `<Labeled>` component to add a label.
 *
 * @example
 * // in src/posts.js
 * import * as React from "react";
 * import { Show, SimpleShowLayout, TextField } from 'react-admin';
 *
 * export const PostShow = () => (
 *     <Show>
 *         <SimpleShowLayout>
 *             <TextField source="title" />
 *         </SimpleShowLayout>
 *     </Show>
 * );
 *
 * // in src/App.js
 * import * as React from "react";
 * import { Admin, Resource } from 'react-admin';
 *
 * import { PostShow } from './posts';
 *
 * const App = () => (
 *     <Admin dataProvider={...}>
 *         <Resource name="posts" show={PostShow} />
 *     </Admin>
 * );
 *
 * @param {SimpleShowLayoutProps} props
 * @param {string} props.className A className to apply to the page content.
 * @param {ElementType} props.component The component to use as root component (div by default).
 * @param {ReactNode} props.divider An optional divider between each field, passed to `<Stack>`.
 * @param {number} props.spacing The spacing to use between each field, passed to `<Stack>`. Defaults to 1.
 * @param {Object} props.sx Custom style object.
 */
export var SimpleShowLayout = function (props) {
    var className = props.className, children = props.children, _a = props.spacing, spacing = _a === void 0 ? 1 : _a, sx = props.sx, rest = __rest(props, ["className", "children", "spacing", "sx"]);
    var record = useRecordContext(props);
    if (!record) {
        return null;
    }
    return (React.createElement(OptionalRecordContextProvider, { value: props.record },
        React.createElement(Root, { className: className, sx: sx },
            React.createElement(Stack, __assign({ spacing: spacing }, sanitizeRestProps(rest), { className: SimpleShowLayoutClasses.stack }), Children.map(children, function (field) {
                return field && isValidElement(field) ? (React.createElement(Labeled, { key: field.props.source, className: clsx('ra-field', field.props.source &&
                        "ra-field-".concat(field.props.source), SimpleShowLayoutClasses.row, field.props.className) }, field)) : null;
            })))));
};
var PREFIX = 'RaSimpleShowLayout';
export var SimpleShowLayoutClasses = {
    stack: "".concat(PREFIX, "-stack"),
    row: "".concat(PREFIX, "-row"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flex: 1,
            padding: "".concat(theme.spacing(1), " ").concat(theme.spacing(2))
        },
        _b["& .".concat(SimpleShowLayoutClasses.stack)] = {},
        _b["& .".concat(SimpleShowLayoutClasses.row)] = {
            display: 'inline',
        },
        _b);
});
var sanitizeRestProps = function (_a) {
    var record = _a.record, resource = _a.resource, initialValues = _a.initialValues, translate = _a.translate, rest = __rest(_a, ["record", "resource", "initialValues", "translate"]);
    return rest;
};
//# sourceMappingURL=SimpleShowLayout.js.map