var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { Children, cloneElement, isValidElement, useState, } from 'react';
import { styled } from '@mui/material/styles';
import { Divider } from '@mui/material';
import { Outlet, Routes, Route } from 'react-router-dom';
import { useRecordContext, OptionalRecordContextProvider, } from 'ra-core';
import { TabbedShowLayoutTabs, getShowLayoutTabFullPath, } from './TabbedShowLayoutTabs';
import { Tab } from './Tab';
/**
 * Layout for a Show view showing fields grouped in tabs and laid out in a single column.
 *
 * It pulls the record from the RecordContext. It renders a set of `<Tabs>`,
 * each of which contains a list of record fields in a single-column layout
 * (via Material UI's `<Stack>` component).
 * `<TabbedShowLayout>` delegates the actual rendering of fields to its children,
 * which should be `<TabbedShowLayout.Tab>` components.
 * `<TabbedShowLayout.Tab>` wraps each field inside a `<Labeled>` component to add a label.
 *
 * @example
 * // in src/posts.js
 * import * as React from "react";
 * import { Show, TabbedShowLayout, TextField } from 'react-admin';
 *
 * export const PostShow = () => (
 *     <Show>
 *         <TabbedShowLayout>
 *             <TabbedShowLayout.Tab label="Content">
 *                 <TextField source="title" />
 *                 <TextField source="subtitle" />
 *            </TabbedShowLayout.Tab>
 *             <TabbedShowLayout.Tab label="Metadata">
 *                 <TextField source="category" />
 *            </TabbedShowLayout.Tab>
 *         </TabbedShowLayout>
 *     </Show>
 * );
 *
 * // in src/App.js
 * import * as React from "react";
 * import { Admin, Resource } from 'react-admin';
 *
 * import { PostShow } from './posts';
 *
 * const App = () => (
 *     <Admin dataProvider={...}>
 *         <Resource name="posts" show={PostShow} />
 *     </Admin>
 * );
 *
 * @param {TabbedShowLayoutProps} props
 * @param {string} props.className A className to apply to the page content.
 * @param {ElementType} props.component The component to use as root component (div by default).
 * @param {ReactNode} props.divider An optional divider between each field, passed to `<Stack>`.
 * @param {number} props.spacing The spacing to use between each field, passed to `<Stack>`. Defaults to 1.
 * @param {Object} props.sx Custom style object.
 * @param {boolean} props.syncWithLocation Whether to update the URL when the tab changes. Defaults to true.
 * @param {ElementType} props.tabs A custom component for rendering tabs.
 */
export var TabbedShowLayout = function (props) {
    var children = props.children, className = props.className, spacing = props.spacing, divider = props.divider, _a = props.syncWithLocation, syncWithLocation = _a === void 0 ? true : _a, _b = props.tabs, tabs = _b === void 0 ? DefaultTabs : _b, value = props.value, rest = __rest(props, ["children", "className", "spacing", "divider", "syncWithLocation", "tabs", "value"]);
    var record = useRecordContext(props);
    var nonNullChildren = Children.toArray(children).filter(function (child) { return child !== null; });
    var _c = useState(0), tabValue = _c[0], setTabValue = _c[1];
    var handleTabChange = function (event, value) {
        if (!syncWithLocation) {
            setTabValue(value);
        }
    };
    if (!record) {
        return null;
    }
    var renderTabHeaders = function () {
        return cloneElement(tabs, {
            onChange: handleTabChange,
            syncWithLocation: syncWithLocation,
            value: tabValue,
        }, nonNullChildren);
    };
    return (React.createElement(OptionalRecordContextProvider, { value: props.record },
        React.createElement(Root, __assign({ className: className }, sanitizeRestProps(rest)), syncWithLocation ? (React.createElement(Routes, null,
            React.createElement(Route, { path: "/*", element: React.createElement(React.Fragment, null,
                    renderTabHeaders(),
                    React.createElement(Divider, null),
                    React.createElement("div", { className: TabbedShowLayoutClasses.content },
                        React.createElement(Outlet, null))) }, Children.map(nonNullChildren, function (tab, index) {
                return isValidElement(tab) ? (React.createElement(Route, { path: getShowLayoutTabFullPath(tab, index), element: cloneElement(tab, {
                        context: 'content',
                        spacing: spacing,
                        divider: divider,
                    }) })) : null;
            })))) : (React.createElement(React.Fragment, null,
            renderTabHeaders(),
            React.createElement(Divider, null),
            React.createElement("div", { className: TabbedShowLayoutClasses.content }, Children.map(nonNullChildren, function (tab, index) {
                if (!isValidElement(tab) ||
                    tabValue !== index) {
                    return null;
                }
                return cloneElement(tab, {
                    context: 'content',
                    spacing: spacing,
                    divider: divider,
                });
            })))))));
};
TabbedShowLayout.Tab = Tab;
var DefaultTabs = React.createElement(TabbedShowLayoutTabs, null);
var PREFIX = 'RaTabbedShowLayout';
export var TabbedShowLayoutClasses = {
    content: "".concat(PREFIX, "-content"),
};
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var _b;
    var theme = _a.theme;
    return (_b = {
            flex: 1
        },
        _b["& .".concat(TabbedShowLayoutClasses.content)] = {
            padding: "".concat(theme.spacing(1), " ").concat(theme.spacing(2)),
        },
        _b);
});
var sanitizeRestProps = function (_a) {
    var record = _a.record, resource = _a.resource, initialValues = _a.initialValues, staticContext = _a.staticContext, translate = _a.translate, tabs = _a.tabs, rest = __rest(_a, ["record", "resource", "initialValues", "staticContext", "translate", "tabs"]);
    return rest;
};
//# sourceMappingURL=TabbedShowLayout.js.map