var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
import * as React from 'react';
import { styled } from '@mui/material/styles';
import DoneIcon from '@mui/icons-material/Done';
import ClearIcon from '@mui/icons-material/Clear';
import { Tooltip, Typography } from '@mui/material';
import { useTranslate, useFieldValue } from 'ra-core';
import { genericMemo } from './genericMemo';
import { sanitizeFieldRestProps } from './sanitizeFieldRestProps';
var BooleanFieldImpl = function (props) {
    var className = props.className, emptyText = props.emptyText, valueLabelTrue = props.valueLabelTrue, valueLabelFalse = props.valueLabelFalse, _a = props.TrueIcon, TrueIcon = _a === void 0 ? DoneIcon : _a, _b = props.FalseIcon, FalseIcon = _b === void 0 ? ClearIcon : _b, _c = props.looseValue, looseValue = _c === void 0 ? false : _c, rest = __rest(props, ["className", "emptyText", "valueLabelTrue", "valueLabelFalse", "TrueIcon", "FalseIcon", "looseValue"]);
    var translate = useTranslate();
    var value = useFieldValue(props);
    var isTruthyValue = value === true || (looseValue && value);
    var ariaLabel = value ? valueLabelTrue : valueLabelFalse;
    if (!ariaLabel) {
        ariaLabel = isTruthyValue ? 'ra.boolean.true' : 'ra.boolean.false';
    }
    if (looseValue || value === false || value === true) {
        return (React.createElement(StyledTypography, __assign({ component: "span", variant: "body2", className: className }, sanitizeFieldRestProps(rest)),
            React.createElement(Tooltip, { title: translate(ariaLabel, { _: ariaLabel }) }, isTruthyValue ? (TrueIcon ? (React.createElement(TrueIcon, { "data-testid": "true", fontSize: "small", className: classes.trueIcon })) : (React.createElement(React.Fragment, null))) : FalseIcon ? (React.createElement(FalseIcon, { "data-testid": "false", fontSize: "small", className: classes.falseIcon })) : (React.createElement(React.Fragment, null)))));
    }
    return (React.createElement(Typography, __assign({ component: "span", variant: "body2", className: className }, sanitizeFieldRestProps(rest)), emptyText && translate(emptyText, { _: emptyText })));
};
BooleanFieldImpl.displayName = 'BooleanFieldImpl';
export var BooleanField = genericMemo(BooleanFieldImpl);
var PREFIX = 'RaBooleanField';
var classes = {
    trueIcon: "".concat(PREFIX, "-trueIcon"),
    falseIcon: "".concat(PREFIX, "-falseIcon"),
};
var StyledTypography = styled(Typography, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})((_a = {
        display: 'inline-flex',
        verticalAlign: 'middle',
        lineHeight: 0
    },
    _a["& .".concat(classes.trueIcon)] = {},
    _a["& .".concat(classes.falseIcon)] = {},
    _a));
//# sourceMappingURL=BooleanField.js.map