var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import get from 'lodash/get';
import Typography from '@mui/material/Typography';
import { useFieldValue, useTranslate, } from 'ra-core';
import { sanitizeFieldRestProps } from './sanitizeFieldRestProps';
import { Link } from '@mui/material';
/**
 * Render a link to a file based on a path contained in a record field
 *
 * @example
 * import { FileField } from 'react-admin';
 *
 * <FileField source="url" title="title" />
 *
 * // renders the record { id: 123, url: 'doc.pdf', title: 'Presentation' } as
 * <div>
 *     <a href="doc.pdf" title="Presentation">Presentation</a>
 * </div>
 */
export var FileField = function (props) {
    var _a, _b;
    var className = props.className, emptyText = props.emptyText, title = props.title, src = props.src, target = props.target, download = props.download, ping = props.ping, rel = props.rel, rest = __rest(props, ["className", "emptyText", "title", "src", "target", "download", "ping", "rel"]);
    var sourceValue = useFieldValue(props);
    var titleValue = (_b = (_a = useFieldValue(__assign(__assign({}, props), { 
        // @ts-ignore We ignore here because title might be a custom label or undefined instead of a field name
        source: title }))) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : title;
    var translate = useTranslate();
    if (!sourceValue) {
        return emptyText ? (React.createElement(Typography, __assign({ component: "span", variant: "body2", className: className }, sanitizeFieldRestProps(rest)), emptyText && translate(emptyText, { _: emptyText }))) : (React.createElement(Root, __assign({ className: className }, sanitizeFieldRestProps(rest))));
    }
    if (Array.isArray(sourceValue)) {
        return (React.createElement(StyledList, __assign({ className: className }, sanitizeFieldRestProps(rest)), sourceValue.map(function (file, index) {
            var fileTitleValue = title
                ? get(file, title, title)
                : title;
            var srcValue = src ? get(file, src, title) : title;
            return (React.createElement("li", { key: index },
                React.createElement(Link, { href: srcValue, title: fileTitleValue, target: target, download: download, ping: ping, rel: rel, variant: "body2", onClick: function (e) { return e.stopPropagation(); } }, fileTitleValue)));
        })));
    }
    return (React.createElement(Root, __assign({ className: className }, sanitizeFieldRestProps(rest)),
        React.createElement(Link, { href: sourceValue === null || sourceValue === void 0 ? void 0 : sourceValue.toString(), title: titleValue, target: target, download: download, ping: ping, rel: rel, variant: "body2" }, titleValue)));
};
var PREFIX = 'RaFileField';
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})({
    display: 'inline-block',
});
var StyledList = styled('ul')({
    display: 'inline-block',
});
//# sourceMappingURL=FileField.js.map