var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
import * as React from 'react';
import { styled } from '@mui/material/styles';
import { Box, Typography } from '@mui/material';
import get from 'lodash/get';
import { useFieldValue, useTranslate, } from 'ra-core';
import { sanitizeFieldRestProps } from './sanitizeFieldRestProps';
export var ImageField = function (props) {
    var _a, _b;
    var className = props.className, emptyText = props.emptyText, src = props.src, title = props.title, rest = __rest(props, ["className", "emptyText", "src", "title"]);
    var sourceValue = useFieldValue(props);
    var titleValue = (_b = (_a = useFieldValue(__assign(__assign({}, props), { 
        // @ts-ignore We ignore here because title might be a custom label or undefined instead of a field name
        source: title }))) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : title;
    var translate = useTranslate();
    if (!sourceValue) {
        return emptyText ? (React.createElement(Typography, __assign({ component: "span", variant: "body2", className: className }, sanitizeFieldRestProps(rest)), emptyText && translate(emptyText, { _: emptyText }))) : (React.createElement(Typography, __assign({ component: "div", className: className }, sanitizeFieldRestProps(rest))));
    }
    if (Array.isArray(sourceValue)) {
        return (React.createElement(Root, __assign({ className: className }, sanitizeFieldRestProps(rest)),
            React.createElement("ul", { className: ImageFieldClasses.list }, sourceValue.map(function (file, index) {
                var fileTitleValue = title
                    ? get(file, title, title)
                    : title;
                var srcValue = src ? get(file, src, title) : title;
                return (React.createElement("li", { key: index },
                    React.createElement("img", { alt: fileTitleValue, title: fileTitleValue, src: srcValue, className: ImageFieldClasses.image })));
            }))));
    }
    return (React.createElement(Root, __assign({ className: className }, sanitizeFieldRestProps(rest)),
        React.createElement("img", { title: titleValue, alt: titleValue, src: sourceValue === null || sourceValue === void 0 ? void 0 : sourceValue.toString(), className: ImageFieldClasses.image })));
};
// What? TypeScript loses the displayName if we don't set it explicitly
ImageField.displayName = 'ImageField';
var PREFIX = 'RaImageField';
export var ImageFieldClasses = {
    list: "".concat(PREFIX, "-list"),
    image: "".concat(PREFIX, "-image"),
};
var Root = styled(Box, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})((_a = {},
    _a["& .".concat(ImageFieldClasses.list)] = {
        display: 'flex',
        listStyleType: 'none',
    },
    _a["& .".concat(ImageFieldClasses.image)] = {
        margin: '0.25rem',
        width: 200,
        height: 100,
        objectFit: 'contain',
    },
    _a));
//# sourceMappingURL=ImageField.js.map