var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import Typography from '@mui/material/Typography';
import { useFieldValue, useTranslate } from 'ra-core';
import { sanitizeFieldRestProps } from './sanitizeFieldRestProps';
import { genericMemo } from './genericMemo';
/**
 * Display a numeric value as a locale string.
 *
 * Uses Intl.NumberFormat() if available, passing the locales and options props as arguments.
 * If Intl is not available, it outputs number as is (and ignores the locales and options props).
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toLocaleString
 * @example
 * <NumberField source="score" />
 * // renders the record { id: 1234, score: 567 } as
 * <span>567</span>
 *
 * <NumberField source="score" className="red" />
 * // renders the record { id: 1234, score: 567 } as
 * <span class="red">567</span>
 *
 * <NumberField source="share" options={{ style: 'percent' }} />
 * // renders the record { id: 1234, share: 0.2545 } as
 * <span>25%</span>
 *
 * <NumberField source="price" options={{ style: 'currency', currency: 'USD' }} />
 * // renders the record { id: 1234, price: 25.99 } as
 * <span>$25.99</span>
 *
 * <NumberField source="price" locales="fr-FR" options={{ style: 'currency', currency: 'USD' }} />
 * // renders the record { id: 1234, price: 25.99 } as
 * <span>25,99 $US</span>
 */
var NumberFieldImpl = function (props) {
    var className = props.className, emptyText = props.emptyText, source = props.source, locales = props.locales, options = props.options, textAlign = props.textAlign, _a = props.transform, transform = _a === void 0 ? defaultTransform : _a, rest = __rest(props, ["className", "emptyText", "source", "locales", "options", "textAlign", "transform"]);
    var translate = useTranslate();
    var value = useFieldValue(props);
    if (value == null) {
        return emptyText ? (React.createElement(Typography, __assign({ component: "span", variant: "body2", className: className }, sanitizeFieldRestProps(rest)), emptyText && translate(emptyText, { _: emptyText }))) : null;
    }
    if (transform) {
        value = transform(value);
    }
    return (React.createElement(Typography, __assign({ variant: "body2", component: "span", className: className }, sanitizeFieldRestProps(rest)), hasNumberFormat && typeof value === 'number'
        ? value.toLocaleString(locales, options)
        : value));
};
var defaultTransform = function (value) {
    return value && typeof value === 'string' && !isNaN(value) ? +value : value;
};
// what? TypeScript loses the displayName if we don't set it explicitly
NumberFieldImpl.displayName = 'NumberFieldImpl';
export var NumberField = genericMemo(NumberFieldImpl);
// @ts-expect-error This is a hack that replaces react support for defaultProps. We currently need this for the Datagrid.
NumberField.textAlign = 'right';
var hasNumberFormat = !!(typeof Intl === 'object' &&
    Intl &&
    typeof Intl.NumberFormat === 'function');
//# sourceMappingURL=NumberField.js.map