var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import Typography from '@mui/material/Typography';
import { useFieldValue, useTranslate } from 'ra-core';
import { sanitizeFieldRestProps } from './sanitizeFieldRestProps';
import { genericMemo } from './genericMemo';
var TextFieldImpl = function (props) {
    var className = props.className, emptyText = props.emptyText, rest = __rest(props, ["className", "emptyText"]);
    var translate = useTranslate();
    var value = useFieldValue(props);
    return (React.createElement(Typography, __assign({ component: "span", variant: "body2", className: className }, sanitizeFieldRestProps(rest)), value != null && typeof value !== 'string'
        ? value.toString()
        : value ||
            (emptyText ? translate(emptyText, { _: emptyText }) : null)));
};
// what? TypeScript loses the displayName if we don't set it explicitly
TextFieldImpl.displayName = 'TextFieldImpl';
export var TextField = genericMemo(TextFieldImpl);
//# sourceMappingURL=TextField.js.map