var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { Children, isValidElement, useMemo, } from 'react';
import { styled } from '@mui/material/styles';
import { useTranslatableContext, RecordContextProvider, useOptionalSourceContext, SourceContextProvider, getResourceFieldLabelKey, useResourceContext, } from 'ra-core';
import { Labeled } from '../Labeled';
/**
 * Default container for a group of translatable fields inside a TranslatableFields components.
 * @see TranslatableFields
 */
export var TranslatableFieldsTabContent = function (props) {
    var children = props.children, _a = props.groupKey, groupKey = _a === void 0 ? '' : _a, locale = props.locale, record = props.record, resourceProp = props.resource, className = props.className, other = __rest(props, ["children", "groupKey", "locale", "record", "resource", "className"]);
    var _b = useTranslatableContext(), selectedLocale = _b.selectedLocale, getRecordForLocale = _b.getRecordForLocale;
    var addLabel = Children.count(children) > 1;
    var parentSourceContext = useOptionalSourceContext();
    var resource = useResourceContext(props);
    if (!resource) {
        throw new Error("<TranslatableFieldsTabContent> was called outside of a ResourceContext and without a record prop. You must set the resource prop.");
    }
    var sourceContext = useMemo(function () { return ({
        getSource: function (source) {
            return parentSourceContext
                ? parentSourceContext.getSource("".concat(source, ".").concat(locale))
                : "".concat(source, ".").concat(locale);
        },
        getLabel: function (source) {
            return parentSourceContext
                ? parentSourceContext.getLabel(source)
                : getResourceFieldLabelKey(resource, source);
        },
    }); }, [locale, parentSourceContext, resource]);
    // As fields rely on the RecordContext to get their values and have no knowledge of the locale,
    // we need to create a new record with the values for the current locale only
    // Given the record { title: { en: 'title_en', fr: 'title_fr' } } and the locale 'fr',
    // the record for the locale 'fr' will be { title: 'title_fr' }
    var recordForLocale = useMemo(function () { return getRecordForLocale(record, locale); }, [getRecordForLocale, record, locale]);
    return (React.createElement(Root, __assign({ role: "tabpanel", hidden: selectedLocale !== locale, id: "translatable-content-".concat(groupKey).concat(locale), "aria-labelledby": "translatable-header-".concat(groupKey).concat(locale), className: className }, other),
        React.createElement(RecordContextProvider, { value: recordForLocale },
            React.createElement(SourceContextProvider, { value: sourceContext }, Children.map(children, function (field) {
                return field && isValidElement(field) ? (React.createElement("div", null, addLabel ? (React.createElement(Labeled
                // Only pass the resource if it was overridden through props to avoid
                // the default inference to potentially override label set by SourceContext
                , { 
                    // Only pass the resource if it was overridden through props to avoid
                    // the default inference to potentially override label set by SourceContext
                    resource: resourceProp, label: field.props.label, source: field.props.source }, field)) : (field))) : null;
            })))));
};
var PREFIX = 'RaTranslatableFieldsTabContent';
var Root = styled('div', {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var theme = _a.theme;
    return ({
        flexGrow: 1,
        padding: theme.spacing(2),
        borderRadius: 0,
        borderBottomLeftRadius: theme.shape.borderRadius,
        borderBottomRightRadius: theme.shape.borderRadius,
        border: "1px solid ".concat(theme.palette.divider),
        borderTop: 0,
    });
});
//# sourceMappingURL=TranslatableFieldsTabContent.js.map