var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { styled } from '@mui/material/styles';
import AppBar from '@mui/material/AppBar';
import Tabs from '@mui/material/Tabs';
import { useTranslatableContext } from 'ra-core';
import { TranslatableFieldsTab } from './TranslatableFieldsTab';
/**
 * Default locale selector for the TranslatableFields component. Generates a tab for each specified locale.
 * @see TranslatableFields
 */
export var TranslatableFieldsTabs = function (props) {
    var groupKey = props.groupKey, tabsProps = props.TabsProps, className = props.className;
    var _a = useTranslatableContext(), locales = _a.locales, selectLocale = _a.selectLocale, selectedLocale = _a.selectedLocale;
    var handleChange = function (event, newLocale) {
        selectLocale(newLocale);
    };
    return (React.createElement(StyledAppBar, { color: "default", position: "static", className: className },
        React.createElement(Tabs, __assign({ value: selectedLocale, onChange: handleChange, indicatorColor: "primary", textColor: "primary" }, tabsProps), locales.map(function (locale) { return (React.createElement(TranslatableFieldsTab, { key: locale, value: locale, locale: locale, groupKey: groupKey })); }))));
};
var PREFIX = 'RaTranslatableFieldsTabs';
var StyledAppBar = styled(AppBar, {
    name: PREFIX,
    overridesResolver: function (props, styles) { return styles.root; },
})(function (_a) {
    var theme = _a.theme;
    return ({
        boxShadow: 'none',
        borderRadius: 0,
        borderTopLeftRadius: theme.shape.borderRadius,
        borderTopRightRadius: theme.shape.borderRadius,
        border: "1px solid ".concat(theme.palette.divider),
    });
});
//# sourceMappingURL=TranslatableFieldsTabs.js.map