var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useResourceContext, usePreference, useStore, useTranslate, } from 'ra-core';
import { Configurable } from '../preferences';
import { SimpleForm } from './SimpleForm';
import { SimpleFormEditor } from './SimpleFormEditor';
export var SimpleFormConfigurable = function (_a) {
    var preferenceKey = _a.preferenceKey, omit = _a.omit, props = __rest(_a, ["preferenceKey", "omit"]);
    var translate = useTranslate();
    var resource = useResourceContext(props);
    var finalPreferenceKey = preferenceKey || "".concat(resource, ".simpleForm");
    var _b = useStore("preferences.".concat(finalPreferenceKey, ".availableInputs"), EMPTY_ARRAY), availableInputs = _b[0], setAvailableInputs = _b[1];
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    var _c = useStore("preferences.".concat(finalPreferenceKey, ".omit"), omit), _ = _c[0], setOmit = _c[1];
    React.useEffect(function () {
        var _a, _b;
        // first render, or the preference have been cleared
        var inputs = (_b = (_a = React.Children.map(props.children, function (child, index) {
            return React.isValidElement(child)
                ? {
                    index: String(index),
                    source: child.props.source,
                    label: child.props.source || child.props.label
                        ? child.props.label
                        : translate('ra.configurable.SimpleForm.unlabeled', {
                            input: index,
                            _: "Unlabeled input #%{input}",
                        }),
                }
                : null;
        })) === null || _a === void 0 ? void 0 : _a.filter(function (column) { return column != null; })) !== null && _b !== void 0 ? _b : EMPTY_ARRAY;
        if (inputs.length !== availableInputs.length) {
            setAvailableInputs(inputs);
            setOmit(omit || EMPTY_ARRAY);
        }
    }, [availableInputs]); // eslint-disable-line react-hooks/exhaustive-deps
    return (React.createElement(Configurable, { editor: React.createElement(SimpleFormEditor, null), preferenceKey: finalPreferenceKey, sx: {
            display: 'block',
            '&.RaConfigurable-editMode': {
                margin: '2px',
            },
        } },
        React.createElement(SimpleFormWithPreferences, __assign({}, props))));
};
var EMPTY_ARRAY = [];
/**
 * This SimpleForm filters its children depending on preferences
 */
var SimpleFormWithPreferences = function (_a) {
    var children = _a.children, props = __rest(_a, ["children"]);
    var availableInputs = usePreference('availableInputs', [])[0];
    var omit = usePreference('omit', [])[0];
    var inputs = usePreference('inputs', availableInputs
        .filter(function (input) { return !(omit === null || omit === void 0 ? void 0 : omit.includes(input.source)); })
        .map(function (input) { return input.index; }))[0];
    var childrenArray = React.Children.toArray(children);
    return (React.createElement(SimpleForm, __assign({}, props), inputs === undefined
        ? children
        : inputs.map(function (index) { return childrenArray[index]; })));
};
//# sourceMappingURL=SimpleFormConfigurable.js.map